/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol;

import com.hazelcast.client.impl.protocol.MessageTaskFactory;
import com.hazelcast.client.impl.protocol.MessageTaskFactoryProvider;
import com.hazelcast.client.impl.protocol.task.management.AddCPGroupViewListenerMessageTask;
import com.hazelcast.client.impl.protocol.task.management.ForceCloseCPSessionTask;
import com.hazelcast.client.impl.protocol.task.management.GetCPMembersMessageTask;
import com.hazelcast.client.impl.protocol.task.management.GetConfigFileContentMessageTask;
import com.hazelcast.client.impl.protocol.task.management.PromoteToCPMemberMessageTask;
import com.hazelcast.client.impl.protocol.task.management.RemoveCPMemberMessageTask;
import com.hazelcast.client.impl.protocol.task.management.ResetCPSubsystemMessageTask;
import com.hazelcast.cp.internal.client.AddCPGroupAvailabilityListenerMessageTask;
import com.hazelcast.cp.internal.client.AddCPMembershipListenerMessageTask;
import com.hazelcast.cp.internal.client.CPSubsystemGetCPGroupIdsMessageTask;
import com.hazelcast.cp.internal.client.CPSubsystemGetCPObjectInfosMessageTask;
import com.hazelcast.cp.internal.client.RemoveCPGroupAvailabilityListenerMessageTask;
import com.hazelcast.cp.internal.client.RemoveCPMembershipListenerMessageTask;
import com.hazelcast.cp.internal.datastructures.atomiclong.client.AddAndGetMessageTask;
import com.hazelcast.cp.internal.datastructures.atomiclong.client.AlterMessageTask;
import com.hazelcast.cp.internal.datastructures.atomiclong.client.ApplyMessageTask;
import com.hazelcast.cp.internal.datastructures.atomiclong.client.CompareAndSetMessageTask;
import com.hazelcast.cp.internal.datastructures.atomiclong.client.GetAndAddMessageTask;
import com.hazelcast.cp.internal.datastructures.atomiclong.client.GetAndSetMessageTask;
import com.hazelcast.cp.internal.datastructures.atomicref.client.ContainsMessageTask;
import com.hazelcast.cp.internal.datastructures.atomicref.client.GetMessageTask;
import com.hazelcast.cp.internal.datastructures.atomicref.client.SetMessageTask;
import com.hazelcast.cp.internal.datastructures.countdownlatch.client.AwaitMessageTask;
import com.hazelcast.cp.internal.datastructures.countdownlatch.client.CountDownMessageTask;
import com.hazelcast.cp.internal.datastructures.countdownlatch.client.GetCountMessageTask;
import com.hazelcast.cp.internal.datastructures.countdownlatch.client.GetRoundMessageTask;
import com.hazelcast.cp.internal.datastructures.countdownlatch.client.TrySetCountMessageTask;
import com.hazelcast.cp.internal.datastructures.cpmap.client.DeleteMessageTask;
import com.hazelcast.cp.internal.datastructures.cpmap.client.PutIfAbsentMessageTask;
import com.hazelcast.cp.internal.datastructures.cpmap.client.PutMessageTask;
import com.hazelcast.cp.internal.datastructures.cpmap.client.RemoveMessageTask;
import com.hazelcast.cp.internal.datastructures.lock.client.GetLockOwnershipStateMessageTask;
import com.hazelcast.cp.internal.datastructures.lock.client.LockMessageTask;
import com.hazelcast.cp.internal.datastructures.lock.client.TryLockMessageTask;
import com.hazelcast.cp.internal.datastructures.lock.client.UnlockMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.AcquirePermitsMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.AvailablePermitsMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.ChangePermitsMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.DrainPermitsMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.GetSemaphoreTypeMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.InitSemaphoreMessageTask;
import com.hazelcast.cp.internal.datastructures.semaphore.client.ReleasePermitsMessageTask;
import com.hazelcast.cp.internal.datastructures.spi.client.CreateRaftGroupMessageTask;
import com.hazelcast.cp.internal.datastructures.spi.client.DestroyRaftObjectMessageTask;
import com.hazelcast.cp.internal.session.client.CloseSessionMessageTask;
import com.hazelcast.cp.internal.session.client.CreateSessionMessageTask;
import com.hazelcast.cp.internal.session.client.GenerateThreadIdMessageTask;
import com.hazelcast.cp.internal.session.client.HeartbeatSessionMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.util.collection.Int2ObjectHashMap;
import com.hazelcast.spi.impl.NodeEngine;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class EnterpriseDefaultMessageTaskFactoryProvider
implements MessageTaskFactoryProvider {
    private final Node node;
    private final Int2ObjectHashMap<MessageTaskFactory> factories;

    public EnterpriseDefaultMessageTaskFactoryProvider(NodeEngine nodeEngine) {
        this.node = nodeEngine.getNode();
        this.factories = new Int2ObjectHashMap();
        this.factories.put(0x202600, (cm, con) -> new GetConfigFileContentMessageTask(cm, this.node, con));
        this.initializeCPGroupTaskFactories();
        this.initializeCPSubsystemMessageTaskFactories();
        this.initializeCPMapTaskFactories();
        this.initializeAtomicLongTaskFactories();
        this.initializeAtomicReferenceTaskFactories();
        this.initializeCountDownLatchTaskFactories();
        this.initializeFencedLockTaskFactories();
        this.initializeSemaphoreTaskFactories();
        this.initializeCPManagementCenterTaskFactories();
    }

    private void initializeCPGroupTaskFactories() {
        this.factories.put(0x1E0100, (cm, con) -> new CreateRaftGroupMessageTask(cm, this.node, con));
        this.factories.put(1966592, (cm, con) -> new DestroyRaftObjectMessageTask(cm, this.node, con));
        this.factories.put(0x1F0100, (cm, con) -> new CreateSessionMessageTask(cm, this.node, con));
        this.factories.put(2032384, (cm, con) -> new HeartbeatSessionMessageTask(cm, this.node, con));
        this.factories.put(2032128, (cm, con) -> new CloseSessionMessageTask(cm, this.node, con));
        this.factories.put(2032640, (cm, con) -> new GenerateThreadIdMessageTask(cm, this.node, con));
    }

    private void initializeCPSubsystemMessageTaskFactories() {
        this.factories.put(0x220100, (cm, con) -> new AddCPMembershipListenerMessageTask(cm, this.node, con));
        this.factories.put(0x220200, (cm, con) -> new RemoveCPMembershipListenerMessageTask(cm, this.node, con));
        this.factories.put(0x220300, (cm, con) -> new AddCPGroupAvailabilityListenerMessageTask(cm, this.node, con));
        this.factories.put(0x220400, (cm, con) -> new RemoveCPGroupAvailabilityListenerMessageTask(cm, this.node, con));
        this.factories.put(0x220500, (cm, con) -> new CPSubsystemGetCPGroupIdsMessageTask(cm, this.node, con));
        this.factories.put(0x220600, (cm, con) -> new CPSubsystemGetCPObjectInfosMessageTask(cm, this.node, con));
        this.factories.put(5888, (cm, con) -> new AddCPGroupViewListenerMessageTask(cm, this.node, con));
    }

    public void initializeCPMapTaskFactories() {
        this.factories.put(2294016, (cm, con) -> new com.hazelcast.cp.internal.datastructures.cpmap.client.GetMessageTask(cm, this.node, con));
        this.factories.put(0x230200, (cm, con) -> new PutMessageTask(cm, this.node, con));
        this.factories.put(0x230300, (cm, con) -> new com.hazelcast.cp.internal.datastructures.cpmap.client.SetMessageTask(cm, this.node, con));
        this.factories.put(2294784, (cm, con) -> new RemoveMessageTask(cm, this.node, con));
        this.factories.put(2295040, (cm, con) -> new DeleteMessageTask(cm, this.node, con));
        this.factories.put(2295296, (cm, con) -> new com.hazelcast.cp.internal.datastructures.cpmap.client.CompareAndSetMessageTask(cm, this.node, con));
        this.factories.put(2295552, (cm, con) -> new PutIfAbsentMessageTask(cm, this.node, con));
    }

    private void initializeAtomicLongTaskFactories() {
        this.factories.put(590592, (cm, con) -> new AddAndGetMessageTask(cm, this.node, con));
        this.factories.put(590848, (cm, con) -> new CompareAndSetMessageTask(cm, this.node, con));
        this.factories.put(591360, (cm, con) -> new GetAndAddMessageTask(cm, this.node, con));
        this.factories.put(591104, (cm, con) -> new com.hazelcast.cp.internal.datastructures.atomiclong.client.GetMessageTask(cm, this.node, con));
        this.factories.put(591616, (cm, con) -> new GetAndSetMessageTask(cm, this.node, con));
        this.factories.put(590080, (cm, con) -> new ApplyMessageTask(cm, this.node, con));
        this.factories.put(590336, (cm, con) -> new AlterMessageTask(cm, this.node, con));
    }

    private void initializeAtomicReferenceTaskFactories() {
        this.factories.put(655616, (cm, con) -> new com.hazelcast.cp.internal.datastructures.atomicref.client.ApplyMessageTask(cm, this.node, con));
        this.factories.put(656640, (cm, con) -> new SetMessageTask(cm, this.node, con));
        this.factories.put(656128, (cm, con) -> new ContainsMessageTask(cm, this.node, con));
        this.factories.put(656384, (cm, con) -> new GetMessageTask(cm, this.node, con));
        this.factories.put(655872, (cm, con) -> new com.hazelcast.cp.internal.datastructures.atomicref.client.CompareAndSetMessageTask(cm, this.node, con));
    }

    private void initializeCountDownLatchTaskFactories() {
        this.factories.put(721408, (cm, con) -> new AwaitMessageTask(cm, this.node, con));
        this.factories.put(721664, (cm, con) -> new CountDownMessageTask(cm, this.node, con));
        this.factories.put(721920, (cm, con) -> new GetCountMessageTask(cm, this.node, con));
        this.factories.put(722176, (cm, con) -> new GetRoundMessageTask(cm, this.node, con));
        this.factories.put(721152, (cm, con) -> new TrySetCountMessageTask(cm, this.node, con));
    }

    private void initializeFencedLockTaskFactories() {
        this.factories.put(459008, (cm, con) -> new LockMessageTask(cm, this.node, con));
        this.factories.put(459264, (cm, con) -> new TryLockMessageTask(cm, this.node, con));
        this.factories.put(459520, (cm, con) -> new UnlockMessageTask(cm, this.node, con));
        this.factories.put(459776, (cm, con) -> new GetLockOwnershipStateMessageTask(cm, this.node, con));
    }

    private void initializeSemaphoreTaskFactories() {
        this.factories.put(786944, (cm, con) -> new AcquirePermitsMessageTask(cm, this.node, con));
        this.factories.put(787968, (cm, con) -> new AvailablePermitsMessageTask(cm, this.node, con));
        this.factories.put(787712, (cm, con) -> new ChangePermitsMessageTask(cm, this.node, con));
        this.factories.put(787456, (cm, con) -> new DrainPermitsMessageTask(cm, this.node, con));
        this.factories.put(788224, (cm, con) -> new GetSemaphoreTypeMessageTask(cm, this.node, con));
        this.factories.put(786688, (cm, con) -> new InitSemaphoreMessageTask(cm, this.node, con));
        this.factories.put(787200, (cm, con) -> new ReleasePermitsMessageTask(cm, this.node, con));
    }

    private void initializeCPManagementCenterTaskFactories() {
        this.factories.put(2103552, (cm, con) -> new GetCPMembersMessageTask(cm, this.node, con));
        this.factories.put(2103808, (cm, con) -> new PromoteToCPMemberMessageTask(cm, this.node, con));
        this.factories.put(2104064, (cm, con) -> new RemoveCPMemberMessageTask(cm, this.node, con));
        this.factories.put(2104320, (cm, con) -> new ResetCPSubsystemMessageTask(cm, this.node, con));
        this.factories.put(0x202400, (cm, con) -> new ForceCloseCPSessionTask(cm, this.node, con));
    }

    @Override
    @SuppressFBWarnings(value={"MS_EXPOSE_REP", "EI_EXPOSE_REP"})
    public Int2ObjectHashMap<MessageTaskFactory> getFactories() {
        return this.factories;
    }
}

