/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.hidensity.operation;

import com.hazelcast.cache.impl.hidensity.operation.CacheLoadAllOperation;
import com.hazelcast.cache.impl.hidensity.operation.HiDensityCacheDataSerializerHook;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationFactory;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class CacheLoadAllOperationFactory
implements OperationFactory,
IdentifiedDataSerializable {
    private String name;
    private Set<Data> keys;
    private boolean replaceExistingValues;

    public CacheLoadAllOperationFactory(String name, Set<Data> keys, boolean replaceExistingValues) {
        this.name = name;
        this.keys = keys;
        this.replaceExistingValues = replaceExistingValues;
    }

    public CacheLoadAllOperationFactory() {
    }

    @Override
    public Operation createOperation() {
        return new CacheLoadAllOperation(this.name, this.keys, this.replaceExistingValues);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.name);
        out.writeBoolean(this.replaceExistingValues);
        out.writeBoolean(this.keys != null);
        if (this.keys != null) {
            out.writeInt(this.keys.size());
            for (Data key : this.keys) {
                IOUtil.writeData(out, key);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readString();
        this.replaceExistingValues = in.readBoolean();
        boolean isKeysNotNull = in.readBoolean();
        if (isKeysNotNull) {
            int size = in.readInt();
            this.keys = new HashSet<Data>(size);
            for (int i = 0; i < size; ++i) {
                Data key = IOUtil.readData(in);
                this.keys.add(key);
            }
        }
    }

    @Override
    public int getFactoryId() {
        return HiDensityCacheDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }
}

