/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheRecordStore;
import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.cache.impl.record.CacheRecordHashMap;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MaxSizePolicy;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.namespace.NamespaceUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.spi.impl.NodeEngine;
import javax.annotation.Nullable;

public class CacheRecordStore
extends AbstractCacheRecordStore<CacheRecord, CacheRecordHashMap> {
    protected SerializationService serializationService;
    @Nullable
    private final String userCodeNamespace;

    public CacheRecordStore(String cacheNameWithPrefix, int partitionId, NodeEngine nodeEngine, AbstractCacheService cacheService) {
        super(cacheNameWithPrefix, partitionId, nodeEngine, cacheService);
        this.serializationService = nodeEngine.getSerializationService();
        this.userCodeNamespace = this.cacheConfig.getUserCodeNamespace();
    }

    @Override
    protected EvictionChecker createCacheEvictionChecker(int size, MaxSizePolicy maxSizePolicy) {
        if (maxSizePolicy == null) {
            throw new IllegalArgumentException("Max-Size policy cannot be null");
        }
        if (maxSizePolicy != MaxSizePolicy.ENTRY_COUNT) {
            throw new IllegalArgumentException("Invalid max-size policy (" + String.valueOf((Object)maxSizePolicy) + ") for " + this.getClass().getName() + "! Only " + String.valueOf((Object)MaxSizePolicy.ENTRY_COUNT) + " is supported.");
        }
        return super.createCacheEvictionChecker(size, maxSizePolicy);
    }

    @Override
    protected CacheRecordHashMap createRecordCacheMap() {
        return new CacheRecordHashMap(this.nodeEngine.getSerializationService(), 256, this.cacheContext);
    }

    @Override
    protected CacheEntryProcessorEntry createCacheEntryProcessorEntry(Data key, CacheRecord record, long now, int completionId) {
        return new CacheEntryProcessorEntry(key, record, this, now, completionId);
    }

    @Override
    protected CacheRecord createRecord(Object value, long creationTime, long expiryTime) {
        this.evictIfRequired();
        this.markExpirable(expiryTime);
        return NamespaceUtil.callWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> this.cacheRecordFactory.newRecordWithExpiry(value, creationTime, expiryTime));
    }

    @Override
    protected Data valueToData(Object value) {
        return NamespaceUtil.callWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> this.cacheService.toData(value));
    }

    @Override
    protected Object dataToValue(Data data) {
        return NamespaceUtil.callWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> this.serializationService.toObject(data));
    }

    @Override
    protected Object recordToValue(CacheRecord record) {
        Object value = record.getValue();
        if (value instanceof Data) {
            Data data = (Data)value;
            return switch (this.cacheConfig.getInMemoryFormat()) {
                case InMemoryFormat.BINARY -> value;
                case InMemoryFormat.OBJECT -> this.dataToValue(data);
                default -> throw new IllegalStateException("Unsupported in-memory format: " + String.valueOf((Object)this.cacheConfig.getInMemoryFormat()));
            };
        }
        return value;
    }

    @Override
    protected Data recordToData(CacheRecord record) {
        Object value = this.recordToValue(record);
        if (value == null) {
            return null;
        }
        if (value instanceof Data) {
            Data data = (Data)value;
            return data;
        }
        return this.valueToData(value);
    }

    @Override
    protected Data toHeapData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            Data data = (Data)obj;
            return data;
        }
        if (obj instanceof CacheRecord) {
            CacheRecord record = (CacheRecord)obj;
            Object value = record.getValue();
            return this.toHeapData(value);
        }
        return NamespaceUtil.callWithNamespace(this.nodeEngine, this.userCodeNamespace, () -> this.serializationService.toData(obj));
    }

    @Override
    public void disposeDeferredBlocks() {
    }
}

