/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.auditlog.impl;

import com.hazelcast.auditlog.AuditableEvent;
import com.hazelcast.auditlog.AuditlogService;
import com.hazelcast.auditlog.EventBuilder;
import com.hazelcast.auditlog.Level;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class SimpleEvent
implements AuditableEvent {
    private final String message;
    private final String typeId;
    private final Map<String, Object> parameters;
    private final Level level;
    private final Throwable cause;
    private final long timestamp;

    private SimpleEvent(Builder builder) {
        this.message = builder.message;
        this.typeId = builder.typeId;
        this.parameters = builder.parameters;
        this.level = builder.level;
        this.cause = builder.cause;
        this.timestamp = builder.timestamp;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String typeId() {
        return this.typeId;
    }

    @Override
    public Map<String, Object> parameters() {
        return this.parameters;
    }

    @Override
    public Level level() {
        return this.level;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "SimpleEvent [typeId=" + this.typeId + ", message=" + this.message + ", timestamp=" + this.timestamp + ", level=" + String.valueOf((Object)this.level) + ", parameters=" + String.valueOf(this.parameters) + ", cause=" + String.valueOf(this.cause) + "]";
    }

    public static Builder builder(String typeId, AuditlogService els) {
        return new Builder(typeId, els);
    }

    public static final class Builder
    implements EventBuilder<Builder> {
        private String message;
        private String typeId;
        private Map<String, Object> parameters = new HashMap<String, Object>();
        private Level level = Level.INFO;
        private Throwable cause;
        private long timestamp;
        private AuditlogService auditlogService;

        private Builder(String typeId, AuditlogService els) {
            this.typeId = Objects.requireNonNull(typeId, "Event type identifier has to be provided.");
            this.auditlogService = els;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public Builder parameters(Map<String, Object> parameters) {
            this.parameters = Objects.requireNonNull(parameters);
            return this;
        }

        @Override
        public Builder addParameter(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        @Override
        public Builder level(Level level) {
            this.level = Objects.requireNonNull(level, "Event importance level has to be provided.");
            return this;
        }

        @Override
        public Builder cause(Throwable throwable) {
            this.cause = throwable;
            return this;
        }

        @Override
        public Builder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public AuditableEvent build() {
            if (this.timestamp <= 0L) {
                this.timestamp = System.currentTimeMillis();
            }
            return new SimpleEvent(this);
        }

        @Override
        public void log() {
            if (this.auditlogService != null) {
                this.auditlogService.log(this.build());
            }
        }
    }
}

