/**
 * This module is the first module imported by the app.
 *
 * It is generated via the backend app containing some crucial data injections for MC UI to work.
 *
 * It also contains some important functions to init other subsystems (like Pendo).
 *
 * refactor: Idealy most of these variables should be fetched from an API call and the config data
 *           sprinkled here should be stored in the global store. It's just that at this point
 *           we're only seperating the UI from Spring the first time. It's already a big change,
 *           so that is an exercize for the future.
 *
 * BEWARE: DO NOT RUN CODE FORMATTERS ON THIS.
 * BEWARE: DO NOT RUN CODE FORMATTERS ON THIS.
 * BEWARE: DO NOT RUN CODE FORMATTERS ON THIS.
 * BEWARE: DO NOT RUN CODE FORMATTERS ON THIS.
 * BEWARE: DO NOT RUN CODE FORMATTERS ON THIS.
 *
 * This is a thymeleaf template and its variable expansion expressions you see
 * below are whitespace-aware. IT WILL BREAK IF THOSE THYMELEAF EXPRESSIONS CHANGE.
 */

/**
 * Bootstraps Pendo, so basically loads Pendo scripts.
 *
 * Call this from the bottom of index page as one usually does.
 */
function bootstrapPendo() {
  if (!window.pendoData.isPendoEnabled) {
    return;
  }

  let pendoApiKey;
  const PENDO_METADATA_FROM_CLOUD_KEY = "pendoMetadataFromCloudConsole";
  let pendoMetadataFromCloudConsole;
  try {
    const storageValue = window.localStorage.getItem(
      PENDO_METADATA_FROM_CLOUD_KEY,
    );

    pendoMetadataFromCloudConsole = JSON.parse(storageValue);
  } catch (e) {}

  if (pendoMetadataFromCloudConsole && pendoMetadataFromCloudConsole.apiKey) {
    pendoApiKey = pendoMetadataFromCloudConsole.apiKey;
  }

  // initialization of pendo is handled in PendoIntegration component.
  (function (apiKey = "c7c4601a-a108-4772-412a-2cb081de8be8") {
    (function (p, e, n, d, o) {
      var v, w, x, y, z;
      o = p[d] = p[d] || {};
      o._q = o._q || [];
      v = ["initialize", "identify", "updateOptions", "pageLoad", "track"];
      for (w = 0, x = v.length; w < x; ++w)
        (function (m) {
          o[m] =
            o[m] ||
            function () {
              o._q[m === v[0] ? "unshift" : "push"](
                [m].concat([].slice.call(arguments, 0)),
              );
            };
        })(v[w]);
      y = e.createElement(n);
      y.async = !0;
      y.src = "https://cdn.pendo.io/agent/static/" + apiKey + "/pendo.js";
      z = e.getElementsByTagName(n)[0];
      z.parentNode.insertBefore(y, z);
    })(window, document, "script", "pendo");
  })(pendoApiKey);
}

/**
 * MC configures its own Pendo metadata (see PendoIntegration component).
 * But if we're in Cloud mode (whether Standalone or Embedded(iframe)), it has to use the Pendo
 * metadata passed from the Cloud Console.
 *
 * Cloud Console passes this metadata via query parameters below (only via this login.html).
 * So we write those values to local storage and PendoIntegration component will use these values
 * while initializing Pendo.
 *
 * You might ask why PendoIntegration component doesn't handle all this... these query parameters will
 * be gone when this login page eventually redirects to homepage.
 *
 * Call this from the bottom of login page as one usually does.
 */
function handlePendoMetadataFromCloudConsole() {
  // TODO: duplicate in PendoIntegration (we should stop adding code to these html files :/)
  const PENDO_METADATA_FROM_CLOUD_KEY = "pendoMetadataFromCloudConsole";

  const url = new URL(window.location.href);

  const accountId = url.searchParams.get("account_id");
  const visitorId = url.searchParams.get("visitor_id");
  const apiKey = url.searchParams.get("api_key");

  const bothGiven = !!accountId & !!visitorId;

  if (bothGiven) {
    const pendoMetadataFromCloudConsole = { accountId, visitorId, apiKey };
    localStorage.setItem(
      PENDO_METADATA_FROM_CLOUD_KEY,
      JSON.stringify(pendoMetadataFromCloudConsole),
    );
  } else {
    // clear this field just in case
    localStorage.removeItem(PENDO_METADATA_FROM_CLOUD_KEY);
  }
}

window.MC_VERSION = /*[[${mcVersion}]]*/ "";

// we need to get the mancenter prefix from JAVA env somehow
window.CONTEXT_PATH = /*[[${contextPath}]]*/ "";
// and make sure it has a leading and tailing /
window.MANCENTER_URL_PREFIX = window.CONTEXT_PATH
  ? `/${window.CONTEXT_PATH.replace(/^\/|\/$/g, "")}/`
  : "/";
window.STATIC_RESOURCES_VERSION = /*[[${staticResourcesVersion}]]*/ "";
window.pendoData = {
  isPendoEnabled: /*[[${pendoData.isPendoEnabled}]]*/ null,
  mcInstanceId: /*[[${pendoData.mcInstanceId}]]*/ null,
  isLicensed: /*[[${pendoData.isLicensed}]]*/ null,
};
window.IS_INTERNAL_CLOUD_MODE = /*[[${isInternalCloudMode}]]*/ false;
window.INTERNAL_FLOW_ADDRESS = /*[[${flowAddress}]]*/ "";
window.CONTEXT_PATH = /*[[${contextPath}]]*/ "";

window.csrfToken = /*[[${_csrf?.token}]]*/ "";
window.csrfHeader = /*[[${_csrf?.headerName}]]*/ "";

window.IS_OLD_CONSOLE_ENABLED = /*[[${isOldConsoleEnabled}]]*/ false;
