/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.protobuf;

import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.Nonnull;

public abstract class ProtobufSerializer<T extends GeneratedMessageV3>
implements StreamSerializer<T> {
    private static final String DEFAULT_INSTANCE_METHOD_NAME = "getDefaultInstance";
    private final int typeId;
    private final Parser<T> parser;

    protected ProtobufSerializer(@Nonnull Class<T> clazz, int typeId) {
        Preconditions.checkTrue((boolean)GeneratedMessageV3.class.isAssignableFrom(clazz), (String)(clazz.getName() + " is not supported, provide a Protocol Buffers " + GeneratedMessageV3.class.getName() + " type"));
        this.typeId = typeId;
        this.parser = this.parser(clazz);
    }

    private Parser<T> parser(Class<T> clazz) {
        try {
            GeneratedMessageV3 defaultMessageInstance = (GeneratedMessageV3)clazz.getMethod(DEFAULT_INSTANCE_METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
            return defaultMessageInstance.getParserForType();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw ExceptionUtil.sneakyThrow((Throwable)e);
        }
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void write(ObjectDataOutput out, T object) throws IOException {
        out.writeByteArray(((AbstractMessageLite)object).toByteArray());
    }

    public T read(ObjectDataInput in) throws IOException {
        return (T)((GeneratedMessageV3)this.parser.parseFrom(in.readByteArray()));
    }

    @Nonnull
    public static <T extends GeneratedMessageV3> ProtobufSerializer<T> from(@Nonnull Class<T> clazz, int typeId) {
        return new ProtobufSerializer<T>((Class)clazz, typeId){};
    }
}

