/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.connect.components.Versioned;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SimpleConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SetSchemaMetadata<R extends ConnectRecord<R>>
implements Transformation<R>,
Versioned {
    private static final Logger log = LoggerFactory.getLogger(SetSchemaMetadata.class);
    public static final String OVERVIEW_DOC = "Set the schema name, version or both on the record's key (<code>" + Key.class.getName() + "</code>) or value (<code>" + Value.class.getName() + "</code>) schema.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("schema.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Schema name to set.").define("schema.version", ConfigDef.Type.INT, null, ConfigDef.Importance.HIGH, "Schema version to set.").define("replace.null.with.default", ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, "Whether to replace fields that have a default value and that are null to the default value. When set to true, the default value is used, otherwise null is used.");
    private String schemaName;
    private Integer schemaVersion;
    private boolean replaceNullWithDefault;

    @Override
    public String version() {
        return AppInfoParser.getVersion();
    }

    @Override
    public void configure(Map<String, ?> configs) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, configs);
        this.schemaName = config.getString("schema.name");
        this.schemaVersion = config.getInt("schema.version");
        this.replaceNullWithDefault = config.getBoolean("replace.null.with.default");
        if (this.schemaName == null && this.schemaVersion == null) {
            throw new ConfigException("Neither schema name nor version configured");
        }
    }

    @Override
    public R apply(R record) {
        Object value = this.operatingValue(record);
        Schema schema = this.operatingSchema(record);
        if (value == null && schema == null) {
            return record;
        }
        Requirements.requireSchema(schema, "updating schema metadata");
        boolean isArray = schema.type() == Schema.Type.ARRAY;
        boolean isMap = schema.type() == Schema.Type.MAP;
        ConnectSchema updatedSchema = new ConnectSchema(schema.type(), schema.isOptional(), schema.defaultValue(), this.schemaName != null ? this.schemaName : schema.name(), this.schemaVersion != null ? this.schemaVersion : schema.version(), schema.doc(), schema.parameters(), schema.fields(), isMap ? schema.keySchema() : null, isMap || isArray ? schema.valueSchema() : null);
        log.trace("Applying SetSchemaMetadata SMT. Original schema: {}, updated schema: {}", (Object)schema, (Object)updatedSchema);
        return this.newRecord(record, updatedSchema);
    }

    private Object getFieldValue(Struct value, Field field) {
        if (this.replaceNullWithDefault) {
            return value.get(field);
        }
        return value.getWithoutDefault(field.name());
    }

    @Override
    public ConfigDef config() {
        return CONFIG_DEF;
    }

    @Override
    public void close() {
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract Object operatingValue(R var1);

    protected abstract R newRecord(R var1, Schema var2);

    protected Object updateSchemaIn(Object keyOrValue, Schema updatedSchema) {
        if (keyOrValue instanceof Struct) {
            Struct origStruct = (Struct)keyOrValue;
            Struct newStruct = new Struct(updatedSchema);
            for (Field field : updatedSchema.fields()) {
                newStruct.put(field, this.getFieldValue(origStruct, field));
            }
            return newStruct;
        }
        return keyOrValue;
    }

    public static class Value<R extends ConnectRecord<R>>
    extends SetSchemaMetadata<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).valueSchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).value();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema) {
            Object updatedValue = this.updateSchemaIn(((ConnectRecord)record).value(), updatedSchema);
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), ((ConnectRecord)record).keySchema(), ((ConnectRecord)record).key(), updatedSchema, updatedValue, ((ConnectRecord)record).timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends SetSchemaMetadata<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return ((ConnectRecord)record).keySchema();
        }

        @Override
        protected Object operatingValue(R record) {
            return ((ConnectRecord)record).key();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema) {
            Object updatedKey = this.updateSchemaIn(((ConnectRecord)record).key(), updatedSchema);
            return ((ConnectRecord)record).newRecord(((ConnectRecord)record).topic(), ((ConnectRecord)record).kafkaPartition(), updatedSchema, updatedKey, ((ConnectRecord)record).valueSchema(), ((ConnectRecord)record).value(), ((ConnectRecord)record).timestamp());
        }
    }

    private static interface ConfigName {
        public static final String SCHEMA_NAME = "schema.name";
        public static final String SCHEMA_VERSION = "schema.version";
        public static final String REPLACE_NULL_WITH_DEFAULT = "replace.null.with.default";
    }
}

