/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.provider;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigData;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.AllowedPaths;
import org.apache.kafka.common.config.provider.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryConfigProvider
implements ConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(DirectoryConfigProvider.class);
    public static final String ALLOWED_PATHS_CONFIG = "allowed.paths";
    public static final String ALLOWED_PATHS_DOC = "A comma separated list of paths that this config provider is allowed to access. If not set, all paths are allowed.";
    private volatile AllowedPaths allowedPaths;

    @Override
    public void configure(Map<String, ?> configs) {
        this.allowedPaths = new AllowedPaths(configs.getOrDefault(ALLOWED_PATHS_CONFIG, null));
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public ConfigData get(String path) {
        return this.get(path, (Path x$0) -> Files.isRegularFile(x$0, new LinkOption[0]));
    }

    @Override
    public ConfigData get(String path, Set<String> keys) {
        return this.get(path, (Path pathname) -> Files.isRegularFile(pathname, new LinkOption[0]) && keys.contains(pathname.getFileName().toString()));
    }

    private ConfigData get(String path, Predicate<Path> fileFilter) {
        if (this.allowedPaths == null) {
            throw new IllegalStateException("The provider has not been configured yet.");
        }
        Map<String, String> map = Collections.emptyMap();
        if (path != null && !path.isEmpty()) {
            Path dir = this.allowedPaths.parseUntrustedPath(path);
            if (dir == null) {
                log.warn("The path {} is not allowed to be accessed", (Object)path);
                return new ConfigData(map);
            }
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                log.warn("The path {} is not a directory", (Object)path);
            } else {
                try (Stream<Path> stream = Files.list(dir);){
                    map = stream.filter(fileFilter).collect(Collectors.toMap(p -> p.getFileName().toString(), p -> DirectoryConfigProvider.read(p)));
                }
                catch (IOException e) {
                    log.error("Could not list directory {}", (Object)dir, (Object)e);
                    throw new ConfigException("Could not list directory " + dir);
                }
            }
        }
        return new ConfigData(map);
    }

    private static String read(Path path) {
        try {
            return new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error("Could not read file {} for property {}", path, path.getFileName(), e);
            throw new ConfigException("Could not read file " + path + " for property " + path.getFileName());
        }
    }
}

