/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import com.hazelcast.jet.cdc.ChangeRecord;
import com.hazelcast.jet.cdc.Operation;
import com.hazelcast.jet.cdc.RecordPart;
import com.hazelcast.jet.cdc.impl.RecordPartImpl;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ChangeRecordImpl
implements ChangeRecord {
    private final long sequenceSource;
    private final long sequenceValue;
    private final String keyJson;
    private final Long timestamp;
    private final Operation operation;
    private final String database;
    private final String schema;
    private final String table;
    private RecordPart key;
    private final RecordPart oldValue;
    private final RecordPart newValue;

    public ChangeRecordImpl(long timestamp, long sequenceSource, long sequenceValue, Operation operation, @Nullable String keyJson, Supplier<String> oldValueJsonSupplier, Supplier<String> newValueJsonSupplier, String table, String schema, String database) {
        this.timestamp = timestamp;
        this.sequenceSource = sequenceSource;
        this.sequenceValue = sequenceValue;
        this.operation = operation;
        this.keyJson = keyJson;
        this.oldValue = oldValueJsonSupplier == null ? null : new RecordPartImpl(oldValueJsonSupplier);
        this.newValue = newValueJsonSupplier == null ? null : new RecordPartImpl(newValueJsonSupplier);
        this.table = table;
        this.schema = schema;
        this.database = database;
    }

    ChangeRecordImpl(long timestamp, long sequenceSource, long sequenceValue, Operation operation, String keyJson, String oldValueJson, String newValueJson, String table, String schema, String database) {
        this.timestamp = timestamp;
        this.sequenceSource = sequenceSource;
        this.sequenceValue = sequenceValue;
        this.operation = operation;
        this.keyJson = keyJson;
        this.oldValue = oldValueJson == null ? null : new RecordPartImpl(oldValueJson);
        this.newValue = newValueJson == null ? null : new RecordPartImpl(newValueJson);
        this.table = table;
        this.schema = schema;
        this.database = database;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.operation;
    }

    @Override
    @Nonnull
    public String database() {
        return this.database;
    }

    @Override
    @Nonnull
    public String schema() {
        return this.schema;
    }

    @Override
    @Nonnull
    public String table() {
        return this.table;
    }

    @Override
    @Nullable
    public RecordPart key() {
        if (this.key == null) {
            if (this.keyJson == null) {
                return null;
            }
            this.key = new RecordPartImpl(() -> this.keyJson);
        }
        return this.key;
    }

    @Override
    @Nonnull
    public RecordPart value() {
        switch (this.operation) {
            case UNSPECIFIED: 
            case SYNC: 
            case INSERT: 
            case UPDATE: {
                return Objects.requireNonNull(this.newValue(), "newValue missing for operation " + String.valueOf((Object)this.operation));
            }
            case DELETE: {
                return Objects.requireNonNull(this.oldValue(), "oldValue missing for operation DELETE");
            }
        }
        throw new IllegalArgumentException("cannot call .value() for operation " + String.valueOf((Object)this.operation));
    }

    @Override
    @Nullable
    public RecordPart newValue() {
        return this.newValue;
    }

    @Override
    @Nullable
    public RecordPart oldValue() {
        return this.oldValue;
    }

    @Override
    @Nonnull
    public String toJson() {
        return String.format("key:{%s}, value:{%s}", this.keyJson, this.value().toJson());
    }

    @Override
    public long sequenceSource() {
        return this.sequenceSource;
    }

    @Override
    public long sequenceValue() {
        return this.sequenceValue;
    }

    public String getKeyJson() {
        return this.keyJson;
    }

    public String toString() {
        return this.toJson();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.sequenceSource, this.sequenceValue, this.keyJson, this.timestamp, this.operation, this.database, this.schema, this.table, this.oldValue, this.newValue});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeRecordImpl that = (ChangeRecordImpl)obj;
        return this.sequenceSource == that.sequenceSource && this.sequenceValue == that.sequenceValue && Objects.equals(this.keyJson, that.keyJson) && Objects.equals(this.timestamp, that.timestamp) && this.operation == that.operation && Objects.equals(this.database, that.database) && Objects.equals(this.schema, that.schema) && Objects.equals(this.table, that.table) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue);
    }
}

