/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.cdc.impl;

import com.hazelcast.jet.cdc.Operation;
import com.hazelcast.jet.cdc.RecordPart;
import com.hazelcast.jet.cdc.impl.CdcSourceP;
import com.hazelcast.jet.cdc.impl.ChangeRecordImpl;
import com.hazelcast.jet.cdc.impl.RecordPartImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerHook;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public class CdcSerializerHooks {

    public static final class CdcSourceStateHook
    implements SerializerHook<CdcSourceP.State> {
        public Class<CdcSourceP.State> getSerializationType() {
            return CdcSourceP.State.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<CdcSourceP.State>(){

                public int getTypeId() {
                    return -342;
                }

                public void write(ObjectDataOutput out, CdcSourceP.State state) throws IOException {
                    out.writeObject(state.getPartitionsToOffset());
                    out.writeInt(state.getHistoryRecords().size());
                    for (byte[] r : state.getHistoryRecords()) {
                        assert (r != null);
                        out.writeObject((Object)r);
                    }
                    out.writeObject(null);
                }

                public CdcSourceP.State read(ObjectDataInput in) throws IOException {
                    byte[] r;
                    Map partitionsToOffset = (Map)in.readObject();
                    int sizeHint = in.readInt();
                    ArrayList<byte[]> historyRecords = new ArrayList<byte[]>(sizeHint);
                    while ((r = (byte[])in.readObject()) != null) {
                        historyRecords.add(r);
                    }
                    return new CdcSourceP.State(partitionsToOffset, new CopyOnWriteArrayList<byte[]>(historyRecords));
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class RecordPartImplHook
    implements SerializerHook<RecordPartImpl> {
        public Class<RecordPartImpl> getSerializationType() {
            return RecordPartImpl.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<RecordPartImpl>(){

                public int getTypeId() {
                    return -341;
                }

                public void write(ObjectDataOutput out, RecordPartImpl part) throws IOException {
                    out.writeString(part.toJson());
                }

                public RecordPartImpl read(ObjectDataInput in) throws IOException {
                    String json = Objects.requireNonNull(in.readString(), "RecordPart.json must not be null");
                    return new RecordPartImpl(json);
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }

    public static final class ChangeRecordImplHook
    implements SerializerHook<ChangeRecordImpl> {
        public Class<ChangeRecordImpl> getSerializationType() {
            return ChangeRecordImpl.class;
        }

        public Serializer createSerializer() {
            return new StreamSerializer<ChangeRecordImpl>(){

                public int getTypeId() {
                    return -340;
                }

                public void write(ObjectDataOutput out, ChangeRecordImpl record) throws IOException {
                    out.writeLong(record.timestamp());
                    out.writeLong(record.sequenceSource());
                    out.writeLong(record.sequenceValue());
                    out.writeString(record.operation().code());
                    out.writeString(record.getKeyJson());
                    RecordPart oldValue = record.oldValue();
                    out.writeString(oldValue == null ? null : oldValue.toJson());
                    RecordPart newValue = record.newValue();
                    out.writeString(newValue == null ? null : newValue.toJson());
                    out.writeString(record.table());
                    out.writeString(record.schema());
                    out.writeString(record.database());
                }

                public ChangeRecordImpl read(ObjectDataInput in) throws IOException {
                    long timestamp = in.readLong();
                    long sequenceSource = in.readLong();
                    long sequenceValue = in.readLong();
                    Operation operation = Operation.get(in.readString());
                    String keyJson = Objects.requireNonNull(in.readString(), "keyJson cannot be null");
                    String oldValueJson = in.readString();
                    String newValueJson = in.readString();
                    String table = in.readString();
                    String schema = in.readString();
                    String database = in.readString();
                    return new ChangeRecordImpl(timestamp, sequenceSource, sequenceValue, operation, keyJson, oldValueJson, newValueJson, table, schema, database);
                }
            };
        }

        public boolean isOverwritable() {
            return true;
        }
    }
}

