/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.google.common.base.Preconditions;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.mongodb.impl.ReadMongoP;
import com.hazelcast.jet.mongodb.impl.ReadMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.ConversionsFromBson;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.jet.sql.impl.connector.mongodb.PlaceholderReplacer;
import com.hazelcast.jet.sql.impl.connector.mongodb.ProjectionData;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;

public class SelectProcessorSupplier
extends MongoProcessorSupplier
implements DataSerializable {
    private FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider;
    private Document predicate;
    private List<ProjectionData> projection;
    private Long startAt;
    private boolean stream;
    private boolean forceMongoParallelismOne;
    private transient ExpressionEvalContext evalContext;

    public SelectProcessorSupplier() {
    }

    SelectProcessorSupplier(MongoTable table, Document predicate, List<ProjectionData> projection, BsonTimestamp startAt, boolean stream, FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        super(table);
        Preconditions.checkArgument(projection != null && !projection.isEmpty(), "projection cannot be empty");
        this.predicate = predicate;
        this.projection = projection;
        this.startAt = startAt == null ? null : Long.valueOf(startAt.getValue());
        this.eventTimePolicyProvider = eventTimePolicyProvider;
        this.stream = stream;
        this.forceMongoParallelismOne = table.isforceReadTotalParallelismOne();
    }

    SelectProcessorSupplier(MongoTable table, Document predicate, List<ProjectionData> projection, BsonTimestamp startAt, FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        this(table, predicate, projection, startAt, true, eventTimePolicyProvider);
    }

    SelectProcessorSupplier(MongoTable table, Document predicate, List<ProjectionData> projection) {
        this(table, predicate, projection, null, false, null);
    }

    public void init(@Nonnull ProcessorSupplier.Context context) {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create(this.connectionString);
        }
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        ReadMongoParams.Aggregates aggregates = new ReadMongoParams.Aggregates();
        if (this.predicate != null) {
            Document filterWithParams = PlaceholderReplacer.replacePlaceholders(this.predicate, this.evalContext, (Object[])null, this.externalNames, false);
            aggregates.setFilter(Mappers.bsonToDocument(Aggregates.match(filterWithParams.toBsonDocument())));
        }
        Bson proj = Projections.fields(this.projection.stream().map(p -> p.projectionExpr).collect(Collectors.toList()));
        List projectedNames = this.projection.stream().map(p -> p.externalName).collect(Collectors.toList());
        if (!projectedNames.contains("_id") && !this.stream) {
            aggregates.setProjection(Mappers.bsonToDocument(Aggregates.project(Projections.fields(proj, Projections.excludeId()))));
        } else {
            aggregates.setProjection(Mappers.bsonToDocument(Aggregates.project(proj)));
        }
        ArrayList processors = new ArrayList();
        EventTimePolicy eventTimePolicy = this.eventTimePolicyProvider == null ? EventTimePolicy.noEventTime() : (EventTimePolicy)this.eventTimePolicyProvider.apply((Object)this.evalContext);
        SupplierEx clientSupplierEx = this.clientSupplier;
        for (int i = 0; i < count; ++i) {
            ReadMongoP processor = new ReadMongoP(new ReadMongoParams(this.stream).setClientSupplier((SupplierEx<MongoClient>)clientSupplierEx).setDataConnectionRef(this.dataConnectionName).setAggregates(aggregates).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setMapItemFn(this::convertDocToRow).setMapStreamFn(this::convertStreamDocToRow).setStartAtTimestamp(this.startAt == null ? null : new BsonTimestamp(this.startAt)).setEventTimePolicy(eventTimePolicy).setNonDistributed(this.forceMongoParallelismOne).setCheckExistenceOnEachConnect(this.checkExistenceOnEachConnect));
            processors.add(processor);
        }
        return processors;
    }

    private JetSqlRow convertDocToRow(Document doc) {
        Object[] row = new Object[this.projection.size()];
        for (ProjectionData entry : this.projection) {
            Object fromDoc = doc.get(entry.externalName);
            int index = entry.index;
            if (entry.type != null) {
                row[index] = ConversionsFromBson.convertFromBson(fromDoc, entry.type);
                continue;
            }
            row[index] = fromDoc;
        }
        return new JetSqlRow((SerializationService)this.evalContext.getSerializationService(), row);
    }

    private JetSqlRow convertStreamDocToRow(ChangeStreamDocument<Document> changeStreamDocument, Long ts) {
        Document doc = changeStreamDocument.getFullDocument();
        Objects.requireNonNull(doc, "Document is empty");
        Object[] row = new Object[this.projection.size()];
        for (ProjectionData entry : this.projection) {
            Object fromDoc = doc.get(entry.externalName.replaceFirst("fullDocument.", ""));
            int index = entry.index;
            if (entry.type != null) {
                row[index] = ConversionsFromBson.convertFromBson(fromDoc, entry.type);
                continue;
            }
            row[index] = fromDoc;
        }
        this.addIfInProjection(changeStreamDocument.getOperationTypeString(), "operationType", row);
        this.addIfInProjection(changeStreamDocument.getResumeToken().toString(), "resumeToken", row);
        this.addIfInProjection(LocalDateTime.ofInstant(Instant.ofEpochMilli(ts), ZoneId.systemDefault()), "ts", row);
        this.addIfInProjection(MongoUtilities.bsonDateTimeToLocalDateTime(changeStreamDocument.getWallTime()), "wallTime", row);
        this.addIfInProjection(MongoUtilities.bsonTimestampToLocalDateTime(changeStreamDocument.getClusterTime()), "clusterTime", row);
        return new JetSqlRow((SerializationService)this.evalContext.getSerializationService(), row);
    }

    private void addIfInProjection(Object value, String field, Object[] row) {
        int index = this.indexInProjection(field);
        if (index == -1) {
            return;
        }
        row[index] = value;
    }

    private int indexInProjection(String columnName) {
        return this.projection.stream().filter(p -> p.externalName.equals(columnName)).map(p -> p.index).findAny().orElse(-1);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.databaseName);
        out.writeString(this.collectionName);
        out.writeBoolean(this.stream);
        out.writeObject(this.eventTimePolicyProvider);
        out.writeObject((Object)this.predicate);
        out.writeObject(this.projection);
        out.writeStringArray(this.externalNames);
        out.writeLong(this.startAt == null ? -1L : this.startAt);
        out.writeString(this.connectionString);
        out.writeString(this.dataConnectionName);
        out.writeBoolean(this.forceMongoParallelismOne);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.databaseName = in.readString();
        this.collectionName = in.readString();
        this.stream = in.readBoolean();
        this.eventTimePolicyProvider = (FunctionEx)in.readObject();
        this.predicate = (Document)in.readObject();
        this.projection = (List)in.readObject();
        this.externalNames = in.readStringArray();
        long startAtDirect = in.readLong();
        this.startAt = startAtDirect == -1L ? null : Long.valueOf(startAtDirect);
        this.connectionString = in.readString();
        this.dataConnectionName = in.readString();
        this.forceMongoParallelismOne = in.readBoolean();
    }
}

