/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.jet.mongodb.ResourceChecks;
import com.hazelcast.jet.mongodb.dataconnection.MongoDataConnection;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Map;
import java.util.function.Predicate;
import org.bson.BsonTimestamp;

final class Options {
    static final String CONNECTION_STRING_OPTION = "connectionString";
    static final String START_AT_OPTION = "startAt";
    static final String PK_COLUMN = "idColumn";
    static final String FORCE_READ_PARALLELISM_ONE = "forceReadTotalParallelismOne";
    static final String CHECK_EXISTENCE = "checkExistence";
    private static final String POSSIBLE_VALUES = "This property should  have value of: a) 'now' b) time in epoch milliseconds or c)  ISO-formatted instant in UTC timezone, like '2023-03-24T15:31:00Z'.";

    private Options() {
    }

    static BsonTimestamp startAtTimestamp(Map<String, String> options) {
        String startAtValue = options.get(START_AT_OPTION);
        if (StringUtil.isNullOrEmpty((String)startAtValue)) {
            throw QueryException.error((String)"startAt property is required for MongoDB stream. This property should  have value of: a) 'now' b) time in epoch milliseconds or c)  ISO-formatted instant in UTC timezone, like '2023-03-24T15:31:00Z'.");
        }
        if ("now".equalsIgnoreCase(startAtValue)) {
            return MongoUtilities.bsonTimestampFromTimeMillis(System.currentTimeMillis());
        }
        try {
            return MongoUtilities.bsonTimestampFromTimeMillis(Long.parseLong(startAtValue));
        }
        catch (NumberFormatException e) {
            try {
                return MongoUtilities.bsonTimestampFromTimeMillis(Instant.parse(startAtValue).toEpochMilli());
            }
            catch (DateTimeParseException ex) {
                throw QueryException.error((String)("Invalid startAt value: '" + startAtValue + "'. This property should  have value of: a) 'now' b) time in epoch milliseconds or c)  ISO-formatted instant in UTC timezone, like '2023-03-24T15:31:00Z'."));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getDatabaseName(NodeEngine nodeEngine, String[] externalName, String dataConnectionName) {
        if (externalName.length == 2) {
            return externalName[0];
        }
        if (dataConnectionName != null) {
            MongoDataConnection dataConnection = (MongoDataConnection)nodeEngine.getDataConnectionService().getAndRetainDataConnection(dataConnectionName, MongoDataConnection.class);
            try {
                String name = dataConnection.getDatabaseName();
                if (name != null) {
                    String string = name;
                    return string;
                }
            }
            finally {
                dataConnection.release();
            }
        }
        throw new IllegalArgumentException("Database must be provided in the mapping or data connection.");
    }

    static Predicate<MappingField> getPkColumnChecker(Map<String, String> options, boolean isStreaming) {
        boolean nonDefault = options.containsKey(PK_COLUMN);
        String defaultIdName = isStreaming ? "fullDocument._id" : "_id";
        String value = options.getOrDefault(PK_COLUMN, defaultIdName);
        if (nonDefault) {
            return mf -> mf.name().equalsIgnoreCase(value);
        }
        return mf -> mf.externalName().equalsIgnoreCase(value);
    }

    static ResourceChecks readExistenceChecksFlag(Map<String, String> options) {
        return ResourceChecks.fromString(options.getOrDefault(CHECK_EXISTENCE, "only-initial"));
    }
}

