/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.google.common.base.Preconditions;
import com.hazelcast.jet.mongodb.ResourceChecks;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTableField;
import com.hazelcast.jet.sql.impl.connector.mongodb.Options;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonType;

class MongoTable
extends JetTable {
    final String databaseName;
    final String collectionName;
    final String connectionString;
    final String dataConnectionName;
    final Map<String, String> options;
    final boolean streaming;
    private final String[] externalNames;
    private final QueryDataType[] fieldTypes;
    private final BsonType[] fieldExternalTypes;
    private final boolean forceReadTotalParallelismOne;
    private final ResourceChecks existenceChecks;

    MongoTable(@Nonnull String schemaName, @Nonnull String name, @Nonnull String databaseName, @Nullable String collectionName, @Nullable String dataConnectionName, @Nonnull Map<String, String> options, @Nonnull SqlConnector sqlConnector, @Nonnull List<TableField> fields, @Nonnull TableStatistics statistics, @Nonnull String objectType) {
        super(sqlConnector, fields, schemaName, name, statistics, objectType, MongoTable.isStreaming(objectType));
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.options = options;
        this.connectionString = options.get("connectionString");
        this.dataConnectionName = dataConnectionName;
        this.streaming = MongoTable.isStreaming(objectType);
        this.existenceChecks = Options.readExistenceChecksFlag(options);
        this.externalNames = (String[])this.getFields().stream().map(field -> ((MongoTableField)field).externalName).toArray(String[]::new);
        this.fieldTypes = (QueryDataType[])this.getFields().stream().map(TableField::getType).toArray(QueryDataType[]::new);
        this.fieldExternalTypes = (BsonType[])this.getFields().stream().map(field -> ((MongoTableField)field).externalType).toArray(BsonType[]::new);
        this.forceReadTotalParallelismOne = Boolean.parseBoolean(options.getOrDefault("forceReadTotalParallelismOne", "false"));
    }

    private static boolean isStreaming(String objectType) {
        return "ChangeStream".equalsIgnoreCase(objectType);
    }

    public MongoTableField getField(String name) {
        for (TableField field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return (MongoTableField)field;
        }
        throw new IllegalArgumentException("field " + name + " does not exist");
    }

    String[] externalNames() {
        return this.externalNames;
    }

    QueryDataType[] fieldTypes() {
        return this.fieldTypes;
    }

    boolean checkExistenceOnEachCall() {
        return this.existenceChecks == ResourceChecks.ONCE_PER_JOB;
    }

    boolean checkExistenceOnEachConnect() {
        return this.existenceChecks == ResourceChecks.ON_EACH_CONNECT;
    }

    QueryDataType fieldType(String externalName) {
        for (TableField f : this.getFields()) {
            MongoTableField mongoTableField = (MongoTableField)f;
            if (!mongoTableField.getExternalName().equals(externalName)) continue;
            return mongoTableField.getType();
        }
        throw new IllegalArgumentException("Unknown column: " + externalName);
    }

    public BsonType[] externalTypes() {
        return this.fieldExternalTypes;
    }

    public PlanObjectKey getObjectKey() {
        return new MongoObjectKey(this.getSchemaName(), this.getSqlName(), this.databaseName, this.collectionName, this.getFields(), this.options);
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String primaryKeyName() {
        List list = this.getFields().stream().filter(field -> ((MongoTableField)((Object)field)).isPrimaryKey()).map(TableField::getName).collect(Collectors.toList());
        Preconditions.checkState(list.size() == 1, "there should be exactly 1 primary key, got: " + String.valueOf(list));
        return (String)list.get(0);
    }

    public String primaryKeyExternalName() {
        List list = this.getFields().stream().filter(field -> ((MongoTableField)((Object)field)).isPrimaryKey()).map(field -> ((MongoTableField)field).externalName).collect(Collectors.toList());
        Preconditions.checkState(list.size() == 1, "there should be exactly 1 primary key, got: " + String.valueOf(list));
        return (String)list.get(0);
    }

    public boolean isforceReadTotalParallelismOne() {
        return this.forceReadTotalParallelismOne;
    }

    public String toString() {
        return "MongoTable{databaseName='" + this.databaseName + "', collectionName='" + this.collectionName + "', connectionString='" + this.connectionString + "', options=" + String.valueOf(this.options) + ", streaming=" + this.streaming + ", forceReadTotalParallelismOne=" + this.forceReadTotalParallelismOne + "}";
    }

    static final class MongoObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String tableName;
        private final String databaseName;
        private final String collectionName;
        private final List<TableField> fields;
        private final Map<String, String> options;

        MongoObjectKey(String schemaName, String tableName, String databaseName, String collectionName, List<TableField> fields, Map<String, String> options) {
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.databaseName = databaseName;
            this.collectionName = collectionName;
            this.fields = fields;
            this.options = options;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MongoObjectKey)) {
                return false;
            }
            MongoObjectKey that = (MongoObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.tableName, that.tableName) && Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.collectionName, that.collectionName) && Objects.equals(this.fields, that.fields) && Objects.equals(this.options, that.options);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.tableName, this.databaseName, this.collectionName, this.fields, this.options);
        }
    }
}

