/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.jet.mongodb.impl.Mappers;
import com.hazelcast.jet.sql.impl.connector.mongodb.InputRef;
import com.hazelcast.jet.sql.impl.connector.mongodb.PlaceholderReplacer;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.bson.Document;
import org.bson.conversions.Bson;

public interface DynamicallyReplacedPlaceholder
extends Serializable {
    @Nonnull
    public String asString();

    public static Document replacePlaceholdersInPredicate(Object predicate, String[] externalNames, ExpressionEvalContext evalContext) {
        if (predicate instanceof String) {
            InputRef ref = InputRef.match(predicate);
            if (ref != null) {
                int index = ref.getInputIndex();
                String colName = externalNames[index];
                return Mappers.bsonToDocument(Aggregates.match(Filters.eq(colName, true)));
            }
            throw new UnsupportedOperationException("unknown predicate " + String.valueOf(predicate));
        }
        if (predicate instanceof Document) {
            return PlaceholderReplacer.replacePlaceholders((Document)predicate, evalContext, (Object[])null, externalNames, false);
        }
        if (!1.$assertionsDisabled && !(predicate instanceof Bson)) {
            throw new AssertionError();
        }
        return Mappers.bsonToDocument((Bson)predicate);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

