/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.HashSet;
import java.util.List;

class DocumentQueryTarget
implements QueryTarget {
    private final List<String> fieldList;
    private Object[] entry;

    DocumentQueryTarget(List<String> fieldList) {
        this.fieldList = fieldList;
        assert (new HashSet<String>(fieldList).size() == fieldList.size()) : "duplicates in the fieldList";
    }

    public void setTarget(Object target, Data targetData) {
        assert (targetData == null);
        Object[] values = ((JetSqlRow)target).getValues();
        this.entry = values;
        assert (this.entry.length == this.fieldList.size());
    }

    public QueryExtractor createExtractor(String path, QueryDataType type) {
        return path == null ? this.createExtractor() : this.createFieldExtractor(path, type);
    }

    private QueryExtractor createExtractor() {
        return () -> this.entry;
    }

    private QueryExtractor createFieldExtractor(String path, QueryDataType type) {
        int fieldIndex = this.fieldList.indexOf(path);
        return () -> type.convert(this.entry[fieldIndex]);
    }
}

