/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.mongodb;

import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.mongodb.MongoSinkBuilder;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.mongodb.impl.UpdateMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoP;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.hazelcast.jet.sql.impl.connector.mongodb.DynamicallyReplacedPlaceholder;
import com.hazelcast.jet.sql.impl.connector.mongodb.MongoTable;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.mongodb.TransactionOptions;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.WriteModel;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.bson.Document;

public class DeleteProcessorSupplier
implements ProcessorSupplier,
DataSerializable {
    private String connectionString;
    private String databaseName;
    private String collectionName;
    private Serializable predicate;
    private String[] externalNames;
    private boolean hasInput;
    private String dataConnectionName;
    private String idField;
    private transient SupplierEx<MongoClient> clientSupplier;
    private ExpressionEvalContext evalContext;

    public DeleteProcessorSupplier() {
    }

    DeleteProcessorSupplier(MongoTable table, Serializable predicate, boolean hasInput) {
        this.connectionString = table.connectionString;
        this.databaseName = table.databaseName;
        this.dataConnectionName = table.dataConnectionName;
        this.collectionName = table.collectionName;
        this.externalNames = table.externalNames();
        this.idField = table.primaryKeyExternalName();
        this.predicate = predicate;
        this.hasInput = hasInput;
    }

    public void init(@Nonnull ProcessorSupplier.Context context) throws Exception {
        if (this.connectionString != null) {
            this.clientSupplier = (SupplierEx & Serializable)() -> MongoClients.create(this.connectionString);
        }
        this.evalContext = ExpressionEvalContext.from((ProcessorMetaSupplier.Context)context);
    }

    @Nonnull
    public Collection<? extends Processor> get(int count) {
        Processor[] processors = new Processor[count];
        for (int i = 0; i < count; ++i) {
            AbstractProcessor processor;
            if (this.hasInput) {
                processor = new WriteMongoP(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Object.class).setCommitRetryStrategy(MongoSinkBuilder.DEFAULT_COMMIT_RETRY_STRATEGY).setTransactionOptionsSup((SupplierEx<TransactionOptions>)(SupplierEx & Serializable)() -> MongoSinkBuilder.DEFAULT_TRANSACTION_OPTION).setIntermediateMappingFn(this::rowToDoc).setWriteModelFn((FunctionEx<Object, WriteModel<Object>>)((FunctionEx & Serializable)this::delete)));
            } else {
                Document predicateWithReplacements = this.predicate == null ? MongoUtilities.UPDATE_ALL_PREDICATE : DynamicallyReplacedPlaceholder.replacePlaceholdersInPredicate(this.predicate, this.externalNames, this.evalContext);
                processor = new UpdateMongoP<Document>(new WriteMongoParams().setClientSupplier(this.clientSupplier).setDataConnectionRef(this.dataConnectionName).setDatabaseName(this.databaseName).setCollectionName(this.collectionName).setDocumentType(Document.class), (SupplierEx & Serializable)() -> new DeleteManyModel(predicateWithReplacements));
            }
            processors[i] = processor;
        }
        return Arrays.asList(processors);
    }

    private WriteModel<Object> delete(Object pkValue) {
        return new DeleteManyModel<Object>(Filters.eq(this.idField, pkValue));
    }

    private Object rowToDoc(JetSqlRow row) {
        assert (row.getFieldCount() == 1);
        return row.getValues()[0];
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.connectionString);
        out.writeString(this.databaseName);
        out.writeString(this.collectionName);
        out.writeObject((Object)this.predicate);
        out.writeStringArray(this.externalNames);
        out.writeBoolean(this.hasInput);
        out.writeString(this.dataConnectionName);
        out.writeString(this.idField);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.connectionString = in.readString();
        this.databaseName = in.readString();
        this.collectionName = in.readString();
        this.predicate = (Serializable)in.readObject();
        this.externalNames = in.readStringArray();
        this.hasInput = in.readBoolean();
        this.dataConnectionName = in.readString();
        this.idField = in.readString();
    }
}

