/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.jet.JetException;
import com.hazelcast.jet.core.AbstractProcessor;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.mongodb.impl.MongoConnection;
import com.hazelcast.jet.mongodb.impl.WriteMongoParams;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.WriteModel;
import java.util.Collections;
import javax.annotation.Nonnull;

public class UpdateMongoP<I>
extends AbstractProcessor {
    private final MongoConnection connection;
    private final String collectionName;
    private final String databaseName;
    private final SupplierEx<WriteModel<I>> writeModelFunction;
    private final Class<I> documentType;

    public UpdateMongoP(WriteMongoParams<I> params, SupplierEx<WriteModel<I>> writeModelFunction) {
        this.connection = new MongoConnection(params.clientSupplier, params.dataConnectionRef, client -> {});
        this.writeModelFunction = writeModelFunction;
        this.documentType = params.documentType;
        this.collectionName = params.collectionName;
        this.databaseName = params.databaseName;
    }

    protected void init(@Nonnull Processor.Context context) {
        this.connection.assembleSupplier(Util.getNodeEngine((HazelcastInstance)context.hazelcastInstance()));
    }

    public void close() {
        IOUtil.closeResource((AutoCloseable)this.connection);
    }

    public boolean isCooperative() {
        return false;
    }

    public boolean complete() {
        if (!this.connection.reconnectIfNecessary()) {
            return false;
        }
        try {
            MongoCollection<I> collection = this.connection.client().getDatabase(this.databaseName).getCollection(this.collectionName, this.documentType);
            WriteModel writeModel = (WriteModel)this.writeModelFunction.get();
            collection.bulkWrite(Collections.singletonList(writeModel));
        }
        catch (Exception e) {
            throw new JetException("Unable to perform query", (Throwable)e);
        }
        return true;
    }
}

