/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.changestream.ChangeStreamDocument;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonTimestamp;
import org.bson.Document;

public class ReadMongoParams<I>
implements Serializable {
    final boolean stream;
    SupplierEx<? extends MongoClient> clientSupplier;
    DataConnectionRef dataConnectionRef;
    String databaseName;
    String collectionName;
    FunctionEx<Document, I> mapItemFn;
    Long startAtTimestamp;
    EventTimePolicy<? super I> eventTimePolicy;
    BiFunctionEx<ChangeStreamDocument<Document>, Long, I> mapStreamFn;
    boolean nonDistributed;
    private boolean checkExistenceOnEachConnect;
    private Aggregates aggregates = new Aggregates();

    public ReadMongoParams(boolean stream) {
        this.stream = stream;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void checkConnectivityOptionsValid() {
        boolean hasDataConnection = this.dataConnectionRef != null;
        boolean hasClientSupplier = this.clientSupplier != null;
        Preconditions.checkState((hasDataConnection || hasClientSupplier ? 1 : 0) != 0, (String)"Client supplier or data connection ref should be provided");
        Preconditions.checkState((hasDataConnection != hasClientSupplier ? 1 : 0) != 0, (String)"Only one of two should be provided: Client supplier or data connection ref");
    }

    @Nonnull
    public SupplierEx<? extends MongoClient> getClientSupplier() {
        return this.clientSupplier;
    }

    public ReadMongoParams<I> setClientSupplier(@Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        this.clientSupplier = clientSupplier;
        return this;
    }

    public DataConnectionRef getDataConnectionRef() {
        return this.dataConnectionRef;
    }

    public ReadMongoParams<I> setDataConnectionRef(DataConnectionRef dataConnectionRef) {
        this.dataConnectionRef = dataConnectionRef;
        return this;
    }

    @Nonnull
    public ReadMongoParams<I> setDataConnectionRef(@Nullable String dataConnectionName) {
        if (dataConnectionName != null) {
            this.setDataConnectionRef(DataConnectionRef.dataConnectionRef((String)dataConnectionName));
        }
        return this;
    }

    @Nonnull
    public Aggregates getAggregates() {
        return this.aggregates;
    }

    @Nonnull
    public ReadMongoParams<I> setAggregates(Aggregates aggregates) {
        this.aggregates = aggregates;
        return this;
    }

    public ReadMongoParams<I> setFilter(Document filter) {
        this.aggregates.filter = filter;
        return this;
    }

    public ReadMongoParams<I> setProjection(Document projection) {
        this.aggregates.projection = projection;
        return this;
    }

    public ReadMongoParams<I> setSort(Document sort) {
        this.aggregates.sort = sort;
        return this;
    }

    @Nonnull
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Nonnull
    public ReadMongoParams<I> setDatabaseName(@Nonnull String databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    @Nonnull
    public String getCollectionName() {
        return this.collectionName;
    }

    public ReadMongoParams<I> setCollectionName(@Nonnull String collectionName) {
        this.collectionName = collectionName;
        return this;
    }

    public FunctionEx<Document, I> getMapItemFn() {
        return this.mapItemFn;
    }

    public ReadMongoParams<I> setMapItemFn(@Nonnull FunctionEx<Document, I> mapItemFn) {
        Util.checkNonNullAndSerializable(mapItemFn, (String)"mapFn");
        this.mapItemFn = mapItemFn;
        return this;
    }

    public BsonTimestamp getStartAtTimestamp() {
        return this.startAtTimestamp == null ? null : new BsonTimestamp(this.startAtTimestamp);
    }

    public ReadMongoParams<I> setStartAtTimestamp(BsonTimestamp startAtTimestamp) {
        this.startAtTimestamp = startAtTimestamp == null ? null : Long.valueOf(startAtTimestamp.getValue());
        return this;
    }

    public EventTimePolicy<? super I> getEventTimePolicy() {
        return this.eventTimePolicy;
    }

    public ReadMongoParams<I> setEventTimePolicy(EventTimePolicy<? super I> eventTimePolicy) {
        this.eventTimePolicy = eventTimePolicy;
        return this;
    }

    public BiFunctionEx<ChangeStreamDocument<Document>, Long, I> getMapStreamFn() {
        return this.mapStreamFn;
    }

    public ReadMongoParams<I> setMapStreamFn(BiFunctionEx<ChangeStreamDocument<Document>, Long, I> mapStreamFn) {
        this.mapStreamFn = mapStreamFn;
        return this;
    }

    public ReadMongoParams<I> setNonDistributed(boolean nonDistributed) {
        this.nonDistributed = nonDistributed;
        return this;
    }

    public boolean isNonDistributed() {
        return this.nonDistributed;
    }

    public boolean isCheckExistenceOnEachConnect() {
        return this.checkExistenceOnEachConnect;
    }

    public ReadMongoParams<I> setCheckExistenceOnEachConnect(boolean checkExistenceOnEachConnect) {
        this.checkExistenceOnEachConnect = checkExistenceOnEachConnect;
        return this;
    }

    public static final class Aggregates
    implements Serializable {
        private Document filter;
        private Document projection;
        private Document sort;

        public List<Document> nonNulls() {
            ArrayList<Document> list = new ArrayList<Document>();
            if (this.filter != null) {
                list.add(this.filter);
            }
            if (this.projection != null) {
                list.add(this.projection);
            }
            if (this.sort != null) {
                list.add(this.sort);
            }
            return list;
        }

        public int indexAfterFilter() {
            return this.filter == null ? 0 : 1;
        }

        public void setFilter(Document filter) {
            this.filter = filter;
        }

        public void setProjection(Document projection) {
            this.projection = projection;
        }

        public void setSort(Document sort) {
            this.sort = sort;
        }

        public Document getFilter() {
            return this.filter;
        }

        public Document getProjection() {
            return this.projection;
        }

        public Document getSort() {
            return this.sort;
        }
    }
}

