/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb.impl;

import com.hazelcast.jet.JetException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Filters;
import com.mongodb.connection.ClusterDescription;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.BsonArray;
import org.bson.BsonDateTime;
import org.bson.BsonString;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class MongoUtilities {
    public static final Document UPDATE_ALL_PREDICATE = Document.parse("{}");

    private MongoUtilities() {
    }

    @Nonnull
    static List<Bson> partitionAggregate(int totalParallelism, int processorIndex, boolean stream) {
        ArrayList<Bson> aggregateList = new ArrayList<Bson>(3);
        String hashFunction = "function hash(s) { \n  var hash = 0, i, chr;\n  if (s.length === 0) return hash;\n  for (i = 0; i < s.length; i++) {\n    chr = s.charCodeAt(i);\n    hash = ((hash << 5) - hash) + chr;\n    hash |= 0;\n  }\n  return hash;\n}\n";
        String moduloPart = " %" + totalParallelism + " == " + processorIndex + ";\n";
        String code = "function(id) {\nif (id instanceof ObjectId)    return id === null ? -1 : id.getTimestamp().getTime() " + moduloPart + "if (typeof(id) === 'number' || typeof(id) === 'bigint') return id " + moduloPart + "if (typeof(id) === 'string') {\n" + hashFunction + "    return hash(id) " + moduloPart + "}\nelse return 0;\n}";
        String idRef = stream ? "$fullDocument._id" : "$_id";
        Document functionInv = new Document("$function", new Document("lang", "js").append("body", code).append("args", new BsonArray(Collections.singletonList(new BsonString(idRef)))));
        aggregateList.add(Aggregates.addFields(new Field<Document>("_thisPartition", functionInv)));
        aggregateList.add(Aggregates.match(Filters.eq("_thisPartition", true)));
        aggregateList.add(Aggregates.unset("_thisPartition"));
        return aggregateList;
    }

    public static BsonTimestamp bsonTimestampFromTimeMillis(long time) {
        return new BsonTimestamp((int)TimeUnit.MILLISECONDS.toSeconds(time), 0);
    }

    @Nullable
    public static BsonTimestamp localDateTimeToTimestamp(@Nullable LocalDateTime time) {
        if (time == null) {
            return null;
        }
        return new BsonTimestamp((int)time.atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toEpochSecond(), 0);
    }

    @Nullable
    public static LocalDateTime bsonDateTimeToLocalDateTime(@Nullable BsonDateTime time) {
        if (time == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(time.getValue());
        return instant.atZone(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    @Nullable
    public static LocalDateTime bsonTimestampToLocalDateTime(@Nullable BsonTimestamp time) {
        if (time == null) {
            return null;
        }
        long v = time.getTime();
        return LocalDateTime.ofEpochSecond(v, 0, ZoneOffset.UTC).atZone(ZoneOffset.UTC).withZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static void checkDatabaseAndCollectionExists(MongoClient client, String databaseName, String collectionName) {
        MongoUtilities.checkDatabaseExists(client, databaseName);
        MongoDatabase database = client.getDatabase(databaseName);
        if (collectionName != null) {
            MongoUtilities.checkCollectionExists(database, collectionName);
        }
    }

    static void checkCollectionExists(MongoDatabase database, String collectionName) {
        for (String name : database.listCollectionNames()) {
            if (!name.equals(collectionName)) continue;
            return;
        }
        throw new JetException("Collection " + collectionName + " in database " + database.getName() + " does not exist");
    }

    static void checkDatabaseExists(MongoClient client, String databaseName) {
        for (String name : client.listDatabaseNames()) {
            if (!name.equalsIgnoreCase(databaseName)) continue;
            return;
        }
        ClusterDescription clusterDescription = client.getClusterDescription();
        throw new JetException("Database " + databaseName + " does not exist in cluster " + String.valueOf(clusterDescription));
    }
}

