/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.mongodb;

import com.hazelcast.function.BiFunctionEx;
import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.mongodb.MongoSourceBuilder;
import com.hazelcast.jet.mongodb.impl.MongoUtilities;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.DataConnectionRef;
import com.hazelcast.jet.pipeline.StreamSource;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class MongoSources {
    private MongoSources() {
    }

    @Nonnull
    public static MongoSourceBuilder.Batch<Document> batch(@Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        return MongoSourceBuilder.batch(clientSupplier);
    }

    @Nonnull
    public static MongoSourceBuilder.Batch<Document> batch(@Nonnull DataConnectionRef dataConnectionRef) {
        return MongoSourceBuilder.batch(dataConnectionRef);
    }

    @Nonnull
    public static BatchSource<Document> batch(@Nonnull String connectionString, @Nonnull String database, @Nonnull String collection, @Nullable Bson filter, @Nullable Bson projection) {
        String name = MongoSources.name(database, collection);
        MongoSourceBuilder.Batch<Document> builder = ((MongoSourceBuilder.Batch)MongoSourceBuilder.batch(name, (SupplierEx<? extends MongoClient>)(SupplierEx & Serializable)() -> MongoClients.create(connectionString)).database(database)).collection(collection);
        if (projection != null) {
            builder.project(projection);
        }
        if (filter != null) {
            builder.filter(filter);
        }
        return builder.build();
    }

    @Nonnull
    public static BatchSource<Document> batch(@Nonnull DataConnectionRef dataConnectionRef, @Nonnull String database, @Nonnull String collection, @Nullable Bson filter, @Nullable Bson projection) {
        String name = MongoSources.name(database, collection);
        MongoSourceBuilder.Batch<Document> builder = ((MongoSourceBuilder.Batch)MongoSourceBuilder.batch(name, dataConnectionRef).database(database)).collection(collection);
        if (projection != null) {
            builder.project(projection);
        }
        if (filter != null) {
            builder.filter(filter);
        }
        return builder.build();
    }

    @Nonnull
    public static MongoSourceBuilder.Stream<Document> stream(@Nonnull SupplierEx<? extends MongoClient> clientSupplier) {
        return MongoSourceBuilder.stream(clientSupplier);
    }

    @Nonnull
    public static StreamSource<? extends Document> stream(@Nonnull String connectionString, @Nonnull String database, @Nonnull String collection, @Nullable Document filter, @Nullable Document projection) {
        String name = MongoSources.name(database, collection);
        MongoSourceBuilder.Stream builder = ((MongoSourceBuilder.Stream)MongoSourceBuilder.stream(name, (SupplierEx<? extends MongoClient>)(SupplierEx & Serializable)() -> MongoClients.create(connectionString)).database(database)).collection(collection).mapFn((BiFunctionEx & Serializable)(d, t2) -> (Document)d.getFullDocument());
        if (projection != null) {
            builder.project(projection);
        }
        if (filter != null) {
            builder.filter(filter);
        }
        builder.startAtOperationTime(MongoUtilities.bsonTimestampFromTimeMillis(System.currentTimeMillis()));
        return builder.build();
    }

    private static String name(String database, String collection) {
        return "MongoSource(" + database + "/" + collection + ")";
    }
}

