/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.IntFunction;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.ObjectRange;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Telemetry;
import software.amazon.s3.analyticsaccelerator.io.physical.PhysicalIO;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Blob;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStore;
import software.amazon.s3.analyticsaccelerator.io.physical.data.MetadataStore;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlan;
import software.amazon.s3.analyticsaccelerator.io.physical.plan.IOPlanExecution;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.request.Range;
import software.amazon.s3.analyticsaccelerator.request.ReadMode;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;
import software.amazon.s3.analyticsaccelerator.util.OpenStreamInformation;
import software.amazon.s3.analyticsaccelerator.util.S3URI;
import software.amazon.s3.analyticsaccelerator.util.StreamAttributes;

public class PhysicalIOImpl
implements PhysicalIO {
    private MetadataStore metadataStore;
    private BlobStore blobStore;
    private final Telemetry telemetry;
    private final OpenStreamInformation openStreamInformation;
    private ObjectKey objectKey;
    private final ObjectMetadata metadata;
    private final ExecutorService threadPool;
    private final long physicalIOBirth = System.nanoTime();
    private static final String OPERATION_READ = "physical.io.read";
    private static final String OPERATION_EXECUTE = "physical.io.execute";
    private static final String FLAVOR_TAIL = "tail";
    private static final String FLAVOR_BYTE = "byte";
    private static final int TMP_BUFFER_MAX_SIZE = 65536;
    private static final Logger LOG = LoggerFactory.getLogger(PhysicalIOImpl.class);

    public PhysicalIOImpl(@NonNull S3URI s3URI, @NonNull MetadataStore metadataStore, @NonNull BlobStore blobStore, @NonNull Telemetry telemetry, @NonNull OpenStreamInformation openStreamInformation, @NonNull ExecutorService threadPool) throws IOException {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (metadataStore == null) {
            throw new NullPointerException("metadataStore is marked non-null but is null");
        }
        if (blobStore == null) {
            throw new NullPointerException("blobStore is marked non-null but is null");
        }
        if (telemetry == null) {
            throw new NullPointerException("telemetry is marked non-null but is null");
        }
        if (openStreamInformation == null) {
            throw new NullPointerException("openStreamInformation is marked non-null but is null");
        }
        if (threadPool == null) {
            throw new NullPointerException("threadPool is marked non-null but is null");
        }
        this.metadataStore = metadataStore;
        this.blobStore = blobStore;
        this.telemetry = telemetry;
        this.openStreamInformation = openStreamInformation;
        this.metadata = this.metadataStore.get(s3URI, openStreamInformation);
        this.objectKey = ObjectKey.builder().s3URI(s3URI).etag(this.metadata.getEtag()).build();
        this.threadPool = threadPool;
    }

    @Override
    public ObjectMetadata metadata() {
        return this.metadata;
    }

    @Override
    public int read(long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        try {
            return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_BYTE))).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(pos, pos))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.openStreamInformation).read(pos));
        }
        catch (Exception e) {
            this.handleOperationExceptions(e);
            throw e;
        }
    }

    @Override
    public int read(byte[] buf, int off, int len, long pos) throws IOException {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Preconditions.checkArgument(pos < this.contentLength(), "`pos` must be less than content length");
        Preconditions.checkArgument(0 <= off, "`off` must not be negative");
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        Preconditions.checkArgument(off < buf.length, "`off` must be less than size of buffer");
        try {
            return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(pos, pos + (long)len - 1L))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.openStreamInformation).read(buf, off, len, pos));
        }
        catch (Exception e) {
            this.handleOperationExceptions(e);
            throw e;
        }
    }

    @Override
    public int readTail(byte[] buf, int off, int len) throws IOException {
        Preconditions.checkArgument(0 <= len, "`len` must not be negative");
        long contentLength = this.contentLength();
        try {
            return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_READ)).attribute(StreamAttributes.variant(FLAVOR_TAIL))).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.range(contentLength - (long)len, contentLength - 1L))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.openStreamInformation).read(buf, off, len, contentLength - (long)len));
        }
        catch (Exception e) {
            this.handleOperationExceptions(e);
            throw e;
        }
    }

    @Override
    public IOPlanExecution execute(IOPlan ioPlan, ReadMode readMode) {
        return this.telemetry.measureVerbose(() -> (Operation)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)((Operation.OperationBuilder)Operation.builder().name(OPERATION_EXECUTE)).attribute(StreamAttributes.uri(this.objectKey.getS3URI()))).attribute(StreamAttributes.etag(this.objectKey.getEtag()))).attribute(StreamAttributes.ioPlan(ioPlan))).attribute(StreamAttributes.physicalIORelativeTimestamp(System.nanoTime() - this.physicalIOBirth))).build(), () -> this.blobStore.get(this.objectKey, this.metadata, this.openStreamInformation).execute(ioPlan, readMode));
    }

    @Override
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="This is complaining about `executor.submit`. In this case we do not have any use for this Future")
    public void readVectored(List<ObjectRange> objectRanges, IntFunction<ByteBuffer> allocate) throws IOException {
        Blob blob = this.blobStore.get(this.objectKey, this.metadata, this.openStreamInformation);
        this.makeReadVectoredRangesAvailable(objectRanges);
        for (ObjectRange objectRange : objectRanges) {
            ByteBuffer buffer = allocate.apply(objectRange.getLength());
            this.threadPool.submit(() -> {
                try {
                    LOG.debug("Starting readVectored for key: {}, range: {} - {}", this.objectKey.getS3URI(), objectRange.getOffset(), objectRange.getOffset() + (long)objectRange.getLength() - 1L);
                    if (buffer.isDirect()) {
                        this.readIntoDirectBuffer(buffer, blob, objectRange);
                        buffer.flip();
                    } else {
                        blob.read(buffer.array(), 0, objectRange.getLength(), objectRange.getOffset());
                    }
                    objectRange.getByteBuffer().complete(buffer);
                }
                catch (Exception e) {
                    objectRange.getByteBuffer().completeExceptionally(e);
                }
            });
        }
    }

    private void readIntoDirectBuffer(ByteBuffer buffer, Blob blob, ObjectRange range) throws IOException {
        int currentLength;
        int length = range.getLength();
        if (length == 0) {
            return;
        }
        long position = range.getOffset();
        int tmpBufferMaxSize = Math.min(65536, length);
        byte[] tmp = new byte[tmpBufferMaxSize];
        for (int readBytes = 0; readBytes < length; readBytes += currentLength) {
            currentLength = readBytes + tmpBufferMaxSize < length ? tmpBufferMaxSize : length - readBytes;
            LOG.debug("Reading {} bytes from position {} (bytes read={}", currentLength, position, readBytes);
            blob.read(tmp, 0, currentLength, position);
            buffer.put(tmp, 0, currentLength);
            position += (long)currentLength;
        }
    }

    private void makeReadVectoredRangesAvailable(List<ObjectRange> objectRanges) {
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (ObjectRange objectRange : objectRanges) {
            ranges.add(new Range(objectRange.getOffset(), objectRange.getOffset() + (long)objectRange.getLength() - 1L));
        }
        this.execute(new IOPlan(ranges), ReadMode.READ_VECTORED);
    }

    private void handleOperationExceptions(Exception e) {
        if (e.getCause() != null && e.getCause().getMessage() != null && (e.getCause().getMessage().contains("Status Code: 412") || e.getCause().getMessage().contains("Error while getting block"))) {
            try {
                this.metadataStore.evictKey(this.objectKey.getS3URI());
            }
            finally {
                this.blobStore.evictKey(this.objectKey);
            }
        }
    }

    private long contentLength() {
        return this.metadata().getContentLength();
    }

    @Override
    public void close(boolean shouldEvict) throws IOException {
        if (shouldEvict) {
            this.blobStore.evictKey(this.objectKey);
        }
    }

    @Override
    public void close() throws IOException {
        this.close(false);
    }
}

