/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.io.physical.data;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Metrics;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.io.physical.data.BlobStoreIndexCache;
import software.amazon.s3.analyticsaccelerator.io.physical.data.Block;
import software.amazon.s3.analyticsaccelerator.request.ObjectMetadata;
import software.amazon.s3.analyticsaccelerator.util.BlockKey;
import software.amazon.s3.analyticsaccelerator.util.MetricKey;
import software.amazon.s3.analyticsaccelerator.util.ObjectKey;

public class BlockStore
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BlockStore.class);
    private final ObjectKey s3URI;
    private final ObjectMetadata metadata;
    private final Map<BlockKey, Block> blocks;
    private final Metrics aggregatingMetrics;
    private final BlobStoreIndexCache indexCache;

    public BlockStore(ObjectKey objectKey, ObjectMetadata metadata, Metrics aggregatingMetrics, BlobStoreIndexCache indexCache) {
        Preconditions.checkNotNull(objectKey, "`objectKey` must not be null");
        Preconditions.checkNotNull(metadata, "`metadata` must not be null");
        this.s3URI = objectKey;
        this.metadata = metadata;
        this.blocks = new LinkedHashMap<BlockKey, Block>();
        this.aggregatingMetrics = aggregatingMetrics;
        this.indexCache = indexCache;
    }

    public boolean isBlockStoreEmpty() {
        return this.blocks.isEmpty();
    }

    public Optional<Block> getBlock(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        Optional<Block> block = this.blocks.values().stream().filter(b -> b.contains(pos)).findFirst();
        if (block.isPresent()) {
            this.aggregatingMetrics.add(MetricKey.CACHE_HIT, 1L);
        } else {
            this.aggregatingMetrics.add(MetricKey.CACHE_MISS, 1L);
        }
        return block;
    }

    public OptionalLong findNextLoadedByte(long pos) {
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        if (this.getBlock(pos).isPresent()) {
            return OptionalLong.of(pos);
        }
        return this.blocks.values().stream().mapToLong(block -> block.getBlockKey().getRange().getStart()).filter(startPos -> pos < startPos).min();
    }

    public OptionalLong findNextMissingByte(long pos) throws IOException {
        Optional<Block> nextBlock;
        Preconditions.checkArgument(0L <= pos, "`pos` must not be negative");
        long nextMissingByte = pos;
        while ((nextBlock = this.getBlock(nextMissingByte)).isPresent()) {
            nextMissingByte = nextBlock.get().getBlockKey().getRange().getEnd() + 1L;
        }
        return nextMissingByte <= this.getLastObjectByte() ? OptionalLong.of(nextMissingByte) : OptionalLong.empty();
    }

    public void add(BlockKey blockKey, Block block) {
        Preconditions.checkNotNull(block, "`block` must not be null");
        this.blocks.put(blockKey, block);
    }

    public void cleanUp() {
        Iterator<Map.Entry<BlockKey, Block>> iterator = this.blocks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<BlockKey, Block> entry = iterator.next();
            BlockKey blockKey = entry.getKey();
            if (!entry.getValue().isDataLoaded() || this.indexCache.contains(blockKey)) continue;
            int range = blockKey.getRange().getLength();
            try {
                iterator.remove();
                this.aggregatingMetrics.reduce(MetricKey.MEMORY_USAGE, range);
                LOG.debug("Removed block with key {}-{}-{} from block store during cleanup", blockKey.getObjectKey().getS3URI(), blockKey.getRange().getStart(), blockKey.getRange().getEnd());
            }
            catch (Exception e) {
                LOG.error("Error in removing block {}", (Object)e.getMessage());
            }
        }
    }

    private long getLastObjectByte() {
        return this.metadata.getContentLength() - 1L;
    }

    private void safeClose(Block block) {
        try {
            block.close();
        }
        catch (Exception e) {
            LOG.error("Exception when closing Block in the BlockStore", e);
        }
    }

    @Override
    public void close() {
        this.blocks.forEach((key, block) -> this.safeClose((Block)block));
    }
}

