/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.s3.analyticsaccelerator.common.Preconditions;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Clock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultEpochClock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Metric;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.MetricMeasurementKind;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapoint;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryReporter;

public class TelemetryDatapointAggregator
implements TelemetryReporter {
    @NonNull
    private final TelemetryReporter telemetryReporter;
    @NonNull
    private final Clock epochClock;
    @NonNull
    private final ConcurrentHashMap<Metric, Aggregation> aggregations = new ConcurrentHashMap();
    private final AtomicReference<ScheduledExecutorService> flushTask;
    private static final Logger LOG = LoggerFactory.getLogger(TelemetryDatapointAggregator.class);

    public TelemetryDatapointAggregator(TelemetryReporter telemetryReporter, Optional<Duration> flushInterval) {
        this(telemetryReporter, flushInterval, DefaultEpochClock.DEFAULT);
    }

    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="We don't actually call a virtual method here, rather set it up for scheduling.")
    TelemetryDatapointAggregator(@NonNull TelemetryReporter telemetryReporter, @NonNull Optional<Duration> flushInterval, @NonNull Clock epochClock) {
        if (telemetryReporter == null) {
            throw new NullPointerException("telemetryReporter is marked non-null but is null");
        }
        if (flushInterval == null) {
            throw new NullPointerException("flushInterval is marked non-null but is null");
        }
        if (epochClock == null) {
            throw new NullPointerException("epochClock is marked non-null but is null");
        }
        this.telemetryReporter = telemetryReporter;
        this.epochClock = epochClock;
        if (flushInterval.isPresent()) {
            ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
            scheduledExecutorService.scheduleAtFixedRate(this::flush, flushInterval.get().toNanos(), flushInterval.get().toNanos(), TimeUnit.NANOSECONDS);
            this.flushTask = new AtomicReference<ScheduledExecutorService>(scheduledExecutorService);
        } else {
            this.flushTask = new AtomicReference();
        }
    }

    @Override
    public void close() {
        try {
            ScheduledExecutorService scheduledExecutorService = this.flushTask.getAndSet(null);
            if (scheduledExecutorService != null) {
                scheduledExecutorService.shutdownNow();
            }
        }
        catch (Exception e) {
            LOG.debug("Error shutting down flush task in TelemetryDatapointAggregator", e);
        }
    }

    @Override
    public void reportStart(long epochTimestampNanos, Operation operation) {
    }

    @Override
    public void reportComplete(TelemetryDatapointMeasurement datapointMeasurement) {
        Metric aggregationKey = (Metric)((Metric.MetricBuilder)Metric.builder().name(datapointMeasurement.getDatapoint().getName())).build();
        Aggregation aggregation = this.aggregations.computeIfAbsent(aggregationKey, key -> new Aggregation(aggregationKey));
        aggregation.accumulate(datapointMeasurement.getValue());
    }

    @Override
    public void flush() {
        LOG.debug("Flushing aggregates");
        this.aggregations.values().forEach(aggregation -> aggregation.flush(this.telemetryReporter));
    }

    @NonNull
    @Generated
    public TelemetryReporter getTelemetryReporter() {
        return this.telemetryReporter;
    }

    @NonNull
    @Generated
    public Clock getEpochClock() {
        return this.epochClock;
    }

    @NonNull
    @Generated
    ConcurrentHashMap<Metric, Aggregation> getAggregations() {
        return this.aggregations;
    }

    class Aggregation {
        @Generated
        private final Object $lock = new Object[0];
        @NonNull
        private final TelemetryDatapoint datapoint;
        private long count = 0L;
        private double sum = 0.0;
        private double min = Double.MAX_VALUE;
        private double max = Double.MIN_VALUE;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void accumulate(double value) {
            Object object = this.$lock;
            synchronized (object) {
                ++this.count;
                this.sum += value;
                if (value < this.min) {
                    this.min = value;
                }
                if (value > this.max) {
                    this.max = value;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void flush(TelemetryReporter reporter) {
            Object object = this.$lock;
            synchronized (object) {
                long epochTimestampNanos = TelemetryDatapointAggregator.this.epochClock.getCurrentTimeNanos();
                Preconditions.checkState(this.count > 0L);
                reporter.reportComplete(this.createMetricMeasurement(epochTimestampNanos, AggregationKind.SUM, this.sum));
                reporter.reportComplete(this.createMetricMeasurement(epochTimestampNanos, AggregationKind.COUNT, this.count));
                reporter.reportComplete(this.createMetricMeasurement(epochTimestampNanos, AggregationKind.AVG, this.sum / (double)this.count));
                reporter.reportComplete(this.createMetricMeasurement(epochTimestampNanos, AggregationKind.MAX, this.max));
                reporter.reportComplete(this.createMetricMeasurement(epochTimestampNanos, AggregationKind.MIN, this.min));
            }
        }

        private MetricMeasurement createMetricMeasurement(long epochTimestampNanos, AggregationKind aggregationKind, double value) {
            Metric metric = (Metric)((Metric.MetricBuilder)Metric.builder().name(this.datapoint.getName() + "." + aggregationKind.value)).build();
            return (MetricMeasurement)((MetricMeasurement.MetricMeasurementBuilder)MetricMeasurement.builder().metric(metric).kind(MetricMeasurementKind.AGGREGATE).epochTimestampNanos(epochTimestampNanos)).value(value).build();
        }

        @Generated
        private Aggregation(TelemetryDatapoint datapoint) {
            if (datapoint == null) {
                throw new NullPointerException("datapoint is marked non-null but is null");
            }
            this.datapoint = datapoint;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        @Generated
        public TelemetryDatapoint getDatapoint() {
            Object object = this.$lock;
            synchronized (object) {
                return this.datapoint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public long getCount() {
            Object object = this.$lock;
            synchronized (object) {
                return this.count;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public double getSum() {
            Object object = this.$lock;
            synchronized (object) {
                return this.sum;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public double getMin() {
            Object object = this.$lock;
            synchronized (object) {
                return this.min;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Generated
        public double getMax() {
            Object object = this.$lock;
            synchronized (object) {
                return this.max;
            }
        }
    }

    static enum AggregationKind {
        SUM("sum"),
        COUNT("count"),
        AVG("avg"),
        MIN("min"),
        MAX("max");

        private final String value;

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        private AggregationKind(String value) {
            this.value = value;
        }
    }
}

