/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultTelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;
import software.amazon.s3.analyticsaccelerator.common.telemetry.OperationMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointMeasurement;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryReporter;
import software.amazon.s3.analyticsaccelerator.util.LogHelper;

class LoggingTelemetryReporter
implements TelemetryReporter {
    @NonNull
    private final EpochFormatter epochFormatter;
    @NonNull
    private final String loggerName;
    @NonNull
    private final Level loggerLevel;
    @NonNull
    private final Logger logger;
    @NonNull
    private final TelemetryFormat telemetryFormat;
    public static Level DEFAULT_LOGGING_LEVEL = Level.DEBUG;
    public static String DEFAULT_LOGGING_NAME = "software.amazon.s3.analyticsaccelerator.telemetry";

    public LoggingTelemetryReporter() {
        this(DEFAULT_LOGGING_NAME, DEFAULT_LOGGING_LEVEL, EpochFormatter.DEFAULT, new DefaultTelemetryFormat());
    }

    public LoggingTelemetryReporter(@NonNull String loggerName, @NonNull Level loggerLevel, @NonNull EpochFormatter epochFormatter, @NonNull TelemetryFormat telemetryFormat) {
        if (loggerName == null) {
            throw new NullPointerException("loggerName is marked non-null but is null");
        }
        if (loggerLevel == null) {
            throw new NullPointerException("loggerLevel is marked non-null but is null");
        }
        if (epochFormatter == null) {
            throw new NullPointerException("epochFormatter is marked non-null but is null");
        }
        if (telemetryFormat == null) {
            throw new NullPointerException("telemetryFormat is marked non-null but is null");
        }
        this.loggerName = loggerName;
        this.epochFormatter = epochFormatter;
        this.loggerLevel = loggerLevel;
        this.logger = LoggerFactory.getLogger(loggerName);
        this.telemetryFormat = telemetryFormat;
    }

    @Override
    public void reportStart(long epochTimestampNanos, Operation operation) {
        LogHelper.logAtLevel(this.logger, this.loggerLevel, this.telemetryFormat.renderOperationStart(operation, epochTimestampNanos, this.epochFormatter), Optional.empty());
    }

    @Override
    public void reportComplete(@NonNull TelemetryDatapointMeasurement datapointMeasurement) {
        OperationMeasurement operationMeasurement;
        if (datapointMeasurement == null) {
            throw new NullPointerException("datapointMeasurement is marked non-null but is null");
        }
        String message = datapointMeasurement.toString(this.telemetryFormat, this.epochFormatter);
        if (datapointMeasurement instanceof OperationMeasurement && (operationMeasurement = (OperationMeasurement)datapointMeasurement).getError().isPresent()) {
            LogHelper.logAtLevel(this.logger, Level.ERROR, message, operationMeasurement.getError());
            return;
        }
        LogHelper.logAtLevel(this.logger, this.loggerLevel, message, Optional.empty());
    }

    @Override
    public void flush() {
    }

    @NonNull
    @Generated
    public EpochFormatter getEpochFormatter() {
        return this.epochFormatter;
    }

    @NonNull
    @Generated
    public String getLoggerName() {
        return this.loggerName;
    }

    @NonNull
    @Generated
    public Level getLoggerLevel() {
        return this.loggerLevel;
    }
}

