/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.event.Level;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultElapsedClock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultEpochClock;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultTelemetry;
import software.amazon.s3.analyticsaccelerator.common.telemetry.DefaultTelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.EpochFormatter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.GroupTelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.JSONTelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.LoggingTelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.NoOpTelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.PrintStreamTelemetryReporter;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryConfiguration;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryDatapointAggregator;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryFormat;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryLevel;
import software.amazon.s3.analyticsaccelerator.common.telemetry.TelemetryReporter;

public class ConfigurableTelemetry
extends DefaultTelemetry {
    public ConfigurableTelemetry(TelemetryConfiguration configuration) {
        this(configuration, ConfigurableTelemetry.createTelemetryReporter(configuration));
    }

    private ConfigurableTelemetry(TelemetryConfiguration configuration, TelemetryReporter telemetryReporter) {
        super(DefaultEpochClock.DEFAULT, DefaultElapsedClock.DEFAULT, telemetryReporter, ConfigurableTelemetry.createTelemetryAggregator(configuration, telemetryReporter), TelemetryLevel.valueOf(configuration.getLevel().toUpperCase(Locale.ROOT)));
    }

    private static TelemetryReporter createTelemetryReporter(TelemetryConfiguration configuration) {
        Optional<Object> loggingReporter = Optional.empty();
        Optional<Object> stdOutTelemetryReporter = Optional.empty();
        if (configuration.isLoggingEnabled()) {
            loggingReporter = Optional.of(new LoggingTelemetryReporter(configuration.getLoggingName(), Level.valueOf(configuration.getLoggingLevel()), EpochFormatter.DEFAULT, ConfigurableTelemetry.createTelemetryFormat(configuration)));
        }
        if (configuration.isStdOutEnabled()) {
            stdOutTelemetryReporter = Optional.of(new PrintStreamTelemetryReporter(System.out, EpochFormatter.DEFAULT, ConfigurableTelemetry.createTelemetryFormat(configuration)));
        }
        if (stdOutTelemetryReporter.isPresent() && loggingReporter.isPresent()) {
            return new GroupTelemetryReporter(Arrays.asList((TelemetryReporter)stdOutTelemetryReporter.get(), (TelemetryReporter)loggingReporter.get()));
        }
        if (loggingReporter.isPresent()) {
            return (TelemetryReporter)loggingReporter.get();
        }
        if (stdOutTelemetryReporter.isPresent()) {
            return (TelemetryReporter)stdOutTelemetryReporter.get();
        }
        return new NoOpTelemetryReporter();
    }

    private static TelemetryFormat createTelemetryFormat(TelemetryConfiguration configuration) {
        switch (configuration.getTelemetryFormat()) {
            case "default": {
                return new DefaultTelemetryFormat();
            }
            case "json": {
                return new JSONTelemetryFormat();
            }
        }
        throw new IllegalArgumentException("Unsupported telemetry format: " + configuration.getTelemetryFormat());
    }

    private static Optional<TelemetryDatapointAggregator> createTelemetryAggregator(TelemetryConfiguration configuration, TelemetryReporter telemetryReporter) {
        if (configuration.isAggregationsEnabled()) {
            TelemetryDatapointAggregator telemetryDatapointAggregator = new TelemetryDatapointAggregator(telemetryReporter, configuration.getAggregationsFlushInterval());
            return Optional.of(telemetryDatapointAggregator);
        }
        return Optional.empty();
    }
}

