/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.model;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.transfer.s3.model.TransferObjectRequest;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
public final class DownloadFileRequest
implements TransferObjectRequest,
ToCopyableBuilder<Builder, DownloadFileRequest> {
    private final Path destination;
    private final GetObjectRequest getObjectRequest;
    private final List<TransferListener> transferListeners;

    private DownloadFileRequest(DefaultBuilder builder) {
        this.destination = (Path)Validate.paramNotNull((Object)builder.destination, (String)"destination");
        this.getObjectRequest = (GetObjectRequest)((Object)Validate.paramNotNull((Object)((Object)builder.getObjectRequest), (String)"getObjectRequest"));
        this.transferListeners = builder.transferListeners;
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    public Path destination() {
        return this.destination;
    }

    public GetObjectRequest getObjectRequest() {
        return this.getObjectRequest;
    }

    @Override
    public List<TransferListener> transferListeners() {
        return this.transferListeners;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadFileRequest that = (DownloadFileRequest)o;
        if (!Objects.equals(this.destination, that.destination)) {
            return false;
        }
        if (!Objects.equals((Object)this.getObjectRequest, (Object)that.getObjectRequest)) {
            return false;
        }
        return Objects.equals(this.transferListeners, that.transferListeners);
    }

    public int hashCode() {
        int result = this.destination != null ? this.destination.hashCode() : 0;
        result = 31 * result + (this.getObjectRequest != null ? this.getObjectRequest.hashCode() : 0);
        result = 31 * result + (this.transferListeners != null ? this.transferListeners.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DownloadFileRequest").add("destination", (Object)this.destination).add("getObjectRequest", (Object)this.getObjectRequest).add("transferListeners", this.transferListeners).build();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return DefaultBuilder.class;
    }

    private static final class DefaultBuilder
    implements Builder {
        private Path destination;
        private GetObjectRequest getObjectRequest;
        private List<TransferListener> transferListeners;

        private DefaultBuilder() {
        }

        private DefaultBuilder(DownloadFileRequest downloadFileRequest) {
            this.destination = downloadFileRequest.destination;
            this.getObjectRequest = downloadFileRequest.getObjectRequest;
            this.transferListeners = downloadFileRequest.transferListeners;
        }

        @Override
        public Builder destination(Path destination) {
            this.destination = (Path)Validate.paramNotNull((Object)destination, (String)"destination");
            return this;
        }

        public Path getDestination() {
            return this.destination;
        }

        public void setDestination(Path destination) {
            this.destination(destination);
        }

        @Override
        public DefaultBuilder getObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest = getObjectRequest;
            return this;
        }

        public GetObjectRequest getGetObjectRequest() {
            return this.getObjectRequest;
        }

        public void setGetObjectRequest(GetObjectRequest getObjectRequest) {
            this.getObjectRequest(getObjectRequest);
        }

        @Override
        public DefaultBuilder transferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners = transferListeners != null ? new ArrayList<TransferListener>(transferListeners) : null;
            return this;
        }

        @Override
        public Builder addTransferListener(TransferListener transferListener) {
            if (this.transferListeners == null) {
                this.transferListeners = new ArrayList<TransferListener>();
            }
            this.transferListeners.add(transferListener);
            return this;
        }

        public List<TransferListener> getTransferListeners() {
            return this.transferListeners;
        }

        public void setTransferListeners(Collection<TransferListener> transferListeners) {
            this.transferListeners((Collection)transferListeners);
        }

        public DownloadFileRequest build() {
            return new DownloadFileRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends CopyableBuilder<Builder, DownloadFileRequest> {
        public Builder destination(Path var1);

        default public Builder destination(File destination) {
            Validate.paramNotNull((Object)destination, (String)"destination");
            return this.destination(destination.toPath());
        }

        public Builder getObjectRequest(GetObjectRequest var1);

        default public Builder getObjectRequest(Consumer<GetObjectRequest.Builder> getObjectRequestBuilder) {
            GetObjectRequest request = (GetObjectRequest)((Object)((GetObjectRequest.Builder)GetObjectRequest.builder().applyMutation(getObjectRequestBuilder)).build());
            this.getObjectRequest(request);
            return this;
        }

        public Builder transferListeners(Collection<TransferListener> var1);

        public Builder addTransferListener(TransferListener var1);
    }
}

