/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.utils;

import java.nio.file.Path;
import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.FileTransformerConfiguration;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadResumeContext;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadUtils;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.internal.utils.FileUtils;
import software.amazon.awssdk.transfer.s3.model.DownloadFileRequest;
import software.amazon.awssdk.transfer.s3.model.ResumableFileDownload;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public final class ResumableRequestConverter {
    private static final Logger log = Logger.loggerFor(S3TransferManager.class);

    private ResumableRequestConverter() {
    }

    public static Pair<DownloadFileRequest, AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> toDownloadFileRequestAndTransformer(ResumableFileDownload resumableFileDownload, HeadObjectResponse headObjectResponse, DownloadFileRequest originalDownloadRequest) {
        boolean fileModified;
        GetObjectRequest getObjectRequest = originalDownloadRequest.getObjectRequest();
        Instant lastModified = resumableFileDownload.s3ObjectLastModified().orElse(null);
        String resumableFileDownloadEtag = resumableFileDownload.s3ObjectEtag().orElse(null);
        String s3ObjectEtag = headObjectResponse.eTag();
        boolean etagModified = resumableFileDownloadEtag != null && !resumableFileDownloadEtag.equals(s3ObjectEtag);
        boolean s3ObjectModified = !headObjectResponse.lastModified().equals(lastModified);
        boolean bl = fileModified = !FileUtils.fileNotModified(resumableFileDownload.bytesTransferred(), resumableFileDownload.fileLastModified(), resumableFileDownload.downloadFileRequest().destination());
        if (fileModified || s3ObjectModified || etagModified) {
            ResumableRequestConverter.logIfNeeded(originalDownloadRequest, getObjectRequest, fileModified, s3ObjectModified, etagModified);
            DownloadFileRequest newDownloadFileRequest = ResumableRequestConverter.newDownloadFileRequest(originalDownloadRequest, getObjectRequest, headObjectResponse);
            AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> responseTransformer = ResumableRequestConverter.fileAsyncResponseTransformer(newDownloadFileRequest, false);
            return Pair.of((Object)newDownloadFileRequest, responseTransformer);
        }
        if (ResumableRequestConverter.hasRemainingParts(getObjectRequest)) {
            log.debug(() -> "The paused download was performed with part GET, now resuming download of remaining parts");
            Long positionToWriteFrom = MultipartDownloadUtils.multipartDownloadResumeContext(originalDownloadRequest.getObjectRequest()).map(MultipartDownloadResumeContext::bytesToLastCompletedParts).orElse(0L);
            AsyncResponseTransformer responseTransformer = AsyncResponseTransformer.toFile((Path)originalDownloadRequest.destination(), (FileTransformerConfiguration)((FileTransformerConfiguration)FileTransformerConfiguration.builder().fileWriteOption(FileTransformerConfiguration.FileWriteOption.WRITE_TO_POSITION).position(positionToWriteFrom).failureBehavior(FileTransformerConfiguration.FailureBehavior.LEAVE).build()));
            return Pair.of((Object)originalDownloadRequest, (Object)responseTransformer);
        }
        log.debug(() -> "The paused download was performed with range GET, now resuming download of remaining bytes.");
        DownloadFileRequest newDownloadFileRequest = ResumableRequestConverter.resumedDownloadFileRequest(resumableFileDownload, originalDownloadRequest, getObjectRequest, headObjectResponse);
        AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> responseTransformer = ResumableRequestConverter.fileAsyncResponseTransformer(newDownloadFileRequest, true);
        return Pair.of((Object)newDownloadFileRequest, responseTransformer);
    }

    private static boolean hasRemainingParts(GetObjectRequest getObjectRequest) {
        Optional<MultipartDownloadResumeContext> optCtx = MultipartDownloadUtils.multipartDownloadResumeContext(getObjectRequest);
        if (!optCtx.isPresent()) {
            return false;
        }
        MultipartDownloadResumeContext ctx = optCtx.get();
        if (ctx.response() != null && ctx.response().partsCount() == null) {
            return false;
        }
        return !ctx.completedParts().isEmpty();
    }

    private static AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> fileAsyncResponseTransformer(DownloadFileRequest newDownloadFileRequest, boolean shouldAppend) {
        FileTransformerConfiguration fileTransformerConfiguration = shouldAppend ? FileTransformerConfiguration.defaultCreateOrAppend() : FileTransformerConfiguration.defaultCreateOrReplaceExisting();
        return AsyncResponseTransformer.toFile((Path)newDownloadFileRequest.destination(), (FileTransformerConfiguration)fileTransformerConfiguration);
    }

    private static void logIfNeeded(DownloadFileRequest downloadRequest, GetObjectRequest getObjectRequest, boolean fileModified, boolean s3ObjectModified, boolean s3ObjectEtagModified) {
        if (log.logger().isDebugEnabled()) {
            if (s3ObjectModified) {
                log.debug(() -> String.format("The requested object in bucket (%s) with key (%s) has been modified on Amazon S3 since the last pause. The SDK will download the S3 object from the beginning", getObjectRequest.bucket(), getObjectRequest.key()));
            }
            if (fileModified) {
                log.debug(() -> String.format("The file (%s) has been modified since the last pause. The SDK will download the requested object in bucket (%s) with key (%s) from the beginning.", downloadRequest.destination(), getObjectRequest.bucket(), getObjectRequest.key()));
            }
            if (s3ObjectEtagModified) {
                log.debug(() -> String.format("The ETag of the requested object in bucket (%s) with key (%s) has changed since the last pause. The SDK will download the S3 object from the beginning", getObjectRequest.bucket(), getObjectRequest.key()));
            }
        }
    }

    private static DownloadFileRequest resumedDownloadFileRequest(ResumableFileDownload resumableFileDownload, DownloadFileRequest downloadRequest, GetObjectRequest getObjectRequest, HeadObjectResponse headObjectResponse) {
        long bytesTransferred = resumableFileDownload.bytesTransferred();
        GetObjectRequest newGetObjectRequest = (GetObjectRequest)((Object)getObjectRequest.toBuilder().ifUnmodifiedSince(headObjectResponse.lastModified()).range("bytes=" + bytesTransferred + "-" + headObjectResponse.contentLength()).build());
        DownloadFileRequest newDownloadFileRequest = (DownloadFileRequest)downloadRequest.toBuilder().getObjectRequest(newGetObjectRequest).build();
        return newDownloadFileRequest;
    }

    private static DownloadFileRequest newDownloadFileRequest(DownloadFileRequest originalDownloadRequest, GetObjectRequest getObjectRequest, HeadObjectResponse headObjectResponse) {
        return (DownloadFileRequest)originalDownloadRequest.toBuilder().getObjectRequest((GetObjectRequest)((Object)getObjectRequest.toBuilder().ifUnmodifiedSince(headObjectResponse.lastModified()).build())).build();
    }
}

