/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.thirdparty.org.slf4j.Logger;
import software.amazon.awssdk.transfer.s3.progress.TransferListener;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TransferListenerInvoker
implements TransferListener {
    private static final software.amazon.awssdk.utils.Logger log = software.amazon.awssdk.utils.Logger.loggerFor(TransferListener.class);
    private final List<TransferListener> listeners;
    private final AtomicBoolean initiated = new AtomicBoolean();
    private final AtomicBoolean complete = new AtomicBoolean();

    public TransferListenerInvoker(List<TransferListener> listeners) {
        this.listeners = (List)Validate.paramNotNull(listeners, (String)"listeners");
    }

    @Override
    public void transferInitiated(TransferListener.Context.TransferInitiated context) {
        if (!this.initiated.getAndSet(true)) {
            this.forEach(listener -> listener.transferInitiated(context));
        }
    }

    @Override
    public void bytesTransferred(TransferListener.Context.BytesTransferred context) {
        this.forEach(listener -> listener.bytesTransferred(context));
    }

    @Override
    public void transferComplete(TransferListener.Context.TransferComplete context) {
        if (!this.complete.getAndSet(true)) {
            this.forEach(listener -> listener.transferComplete(context));
        }
    }

    @Override
    public void transferFailed(TransferListener.Context.TransferFailed context) {
        if (!this.complete.getAndSet(true)) {
            this.forEach(listener -> listener.transferFailed(context));
        }
    }

    private void forEach(Consumer<TransferListener> action) {
        for (TransferListener listener : this.listeners) {
            FunctionalUtils.runAndLogError((Logger)log.logger(), (String)"Exception thrown in TransferListener, ignoring", () -> action.accept(listener));
        }
    }
}

