/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.progress;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.transfer.s3.internal.progress.DefaultTransferProgressSnapshot;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.transfer.s3.progress.TransferProgressSnapshot;
import software.amazon.awssdk.utils.ToString;

@Mutable
@ThreadSafe
@SdkInternalApi
public final class DefaultTransferProgress
implements TransferProgress {
    private final AtomicReference<TransferProgressSnapshot> snapshot;

    public DefaultTransferProgress(TransferProgressSnapshot snapshot) {
        this.snapshot = new AtomicReference<TransferProgressSnapshot>(snapshot);
    }

    public TransferProgressSnapshot updateAndGet(Consumer<DefaultTransferProgressSnapshot.Builder> updater) {
        return this.snapshot.updateAndGet(s2 -> (TransferProgressSnapshot)((DefaultTransferProgressSnapshot)s2).copy(updater));
    }

    @Override
    public TransferProgressSnapshot snapshot() {
        return this.snapshot.get();
    }

    public String toString() {
        return ToString.builder((String)"TransferProgress").add("snapshot", this.snapshot).build();
    }
}

