/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.model.AbortMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.internal.utils.FileUtils;
import software.amazon.awssdk.transfer.s3.model.ResumableFileUpload;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class PauseResumeHelper {
    private static final Logger log = Logger.loggerFor(PauseResumeHelper.class);

    protected boolean fileModified(ResumableFileUpload resumableFileUpload, S3AsyncClient s3AsyncClient) {
        boolean fileModified;
        boolean bl = fileModified = !FileUtils.fileNotModified(resumableFileUpload.fileLength(), resumableFileUpload.fileLastModified(), resumableFileUpload.uploadFileRequest().source());
        if (fileModified) {
            UploadFileRequest uploadFileRequest = resumableFileUpload.uploadFileRequest();
            PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
            log.debug(() -> String.format("The file (%s) has been modified since the last pause. The SDK will upload the requested object in bucket (%s) with key (%s) from the beginning.", uploadFileRequest.source(), putObjectRequest.bucket(), putObjectRequest.key()));
            resumableFileUpload.multipartUploadId().ifPresent(id -> {
                log.debug(() -> "Aborting previous upload with multipartUploadId: " + id);
                s3AsyncClient.abortMultipartUpload((AbortMultipartUploadRequest)((Object)((Object)AbortMultipartUploadRequest.builder().bucket(putObjectRequest.bucket()).key(putObjectRequest.key()).uploadId((String)id).build()))).exceptionally(t2 -> {
                    log.warn(() -> String.format("Failed to abort previous multipart upload (id: %s). You may need to call S3AsyncClient#abortMultiPartUpload to free all storage consumed by all parts. ", id), t2);
                    return null;
                });
            });
        }
        return fileModified;
    }

    protected boolean hasResumeToken(ResumableFileUpload resumableFileUpload) {
        boolean hasResumeToken;
        boolean bl = hasResumeToken = resumableFileUpload.totalParts().isPresent() && resumableFileUpload.partSizeInBytes().isPresent();
        if (!hasResumeToken) {
            UploadFileRequest uploadFileRequest = resumableFileUpload.uploadFileRequest();
            PutObjectRequest putObjectRequest = uploadFileRequest.putObjectRequest();
            log.debug(() -> String.format("No resume token is found. The SDK will upload the requested object in bucket (%s) with key (%s) from the beginning.", putObjectRequest.bucket(), putObjectRequest.key()));
        }
        return hasResumeToken;
    }
}

