/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.thirdparty.org.slf4j.impl.internal;

import java.util.Iterator;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.thirdparty.org.slf4j.Marker;
import software.amazon.awssdk.thirdparty.org.slf4j.impl.internal.MarkerUtils;

@SdkInternalApi
public class ShadedMarkerAdapter
implements Marker {
    private static final long serialVersionUID = -8764719723630669060L;
    private final org.slf4j.Marker unshaded;

    public ShadedMarkerAdapter(org.slf4j.Marker unshaded) {
        this.unshaded = unshaded;
    }

    public org.slf4j.Marker getUnshaded() {
        return this.unshaded;
    }

    @Override
    public String getName() {
        return this.unshaded.getName();
    }

    @Override
    public void add(Marker marker) {
        this.unshaded.add(MarkerUtils.asUnshaded(marker));
    }

    @Override
    public boolean remove(Marker marker) {
        return this.unshaded.remove(MarkerUtils.asUnshaded(marker));
    }

    @Override
    public boolean hasChildren() {
        return this.unshaded.hasChildren();
    }

    @Override
    public boolean hasReferences() {
        return this.unshaded.hasReferences();
    }

    @Override
    public Iterator<Marker> iterator() {
        return new IteratorAdapter(this.unshaded.iterator());
    }

    @Override
    public boolean contains(Marker marker) {
        return this.unshaded.contains(MarkerUtils.asUnshaded(marker));
    }

    @Override
    public boolean contains(String s2) {
        return this.unshaded.contains(s2);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Marker)) {
            return false;
        }
        Marker that = (Marker)o;
        return this.unshaded.getName().equals(that.getName());
    }

    @Override
    public int hashCode() {
        return this.unshaded.hashCode();
    }

    private static class IteratorAdapter
    implements Iterator<Marker> {
        private final Iterator<org.slf4j.Marker> unshaded;

        IteratorAdapter(Iterator<org.slf4j.Marker> unshaded) {
            this.unshaded = unshaded;
        }

        @Override
        public boolean hasNext() {
            return this.unshaded.hasNext();
        }

        @Override
        public Marker next() {
            return MarkerUtils.asShaded(this.unshaded.next());
        }

        @Override
        public void remove() {
            this.unshaded.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super Marker> action) {
            this.unshaded.forEachRemaining((? super E m4) -> action.accept(MarkerUtils.asShaded(m4)));
        }
    }
}

