/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.thirdparty.org.slf4j.impl.internal;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class InvocationHelper {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private InvocationHelper() {
    }

    public static Optional<MethodHandle> staticHandle(Class<?> refc, String name, MethodType mt) {
        try {
            return Optional.of(LOOKUP.findStatic(refc, name, mt));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public static Optional<MethodHandle> virtualHandle(Class<?> refc, String name, MethodType mt) {
        try {
            return Optional.of(LOOKUP.findVirtual(refc, name, mt));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            return Optional.empty();
        }
    }

    public static MethodHandle cachedGetHandle(AtomicReference<MethodHandle> ref, Supplier<MethodHandle> creator) {
        if (ref.get() != null) {
            return ref.get();
        }
        return ref.updateAndGet(mh -> {
            if (mh != null) {
                return mh;
            }
            return (MethodHandle)creator.get();
        });
    }
}

