/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.thirdparty.org.slf4j.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkTestInternalApi;
import software.amazon.awssdk.thirdparty.org.slf4j.IMarkerFactory;
import software.amazon.awssdk.thirdparty.org.slf4j.impl.internal.ErrorUtil;
import software.amazon.awssdk.thirdparty.org.slf4j.impl.internal.IMarkerFactoryAdapter;
import software.amazon.awssdk.thirdparty.org.slf4j.impl.internal.InvocationHelper;

@SdkInternalApi
public class StaticMarkerBinder {
    private static final String LOGGER_BINDER_NAME = "org.slf4j.impl.StaticMarkerBinder";
    private static final AtomicReference<MethodHandle> GET_SINGLETON = new AtomicReference();
    private static final AtomicReference<MethodHandle> GET_MARKER_FACTORY = new AtomicReference();
    private static final Class<?> BINDER_CLASS;
    private static final Object IMPL;
    private static final State STATE;
    private static final StaticMarkerBinder INSTANCE;

    public static StaticMarkerBinder getSingleton() {
        if (STATE != State.INIT_SUCCESS) {
            throw new NoClassDefFoundError(StaticMarkerBinder.class.getCanonicalName());
        }
        return INSTANCE;
    }

    public IMarkerFactory getMarkerFactory() {
        MethodHandle mh = InvocationHelper.cachedGetHandle(GET_MARKER_FACTORY, () -> InvocationHelper.virtualHandle(BINDER_CLASS, "getMarkerFactory", MethodType.methodType(org.slf4j.IMarkerFactory.class)).orElse(null));
        if (mh == null) {
            throw new RuntimeException(new NoSuchMethodException("getMarkerFactory"));
        }
        try {
            org.slf4j.IMarkerFactory realFactory = mh.invoke(IMPL);
            return new IMarkerFactoryAdapter(realFactory);
        }
        catch (Throwable t2) {
            throw new RuntimeException(t2);
        }
    }

    public String getMarkerFactoryClassStr() {
        return IMarkerFactoryAdapter.class.getCanonicalName();
    }

    @SdkTestInternalApi
    Object getActualStaticMarkerBinder() {
        return IMPL;
    }

    static {
        Class<?> binderClass = null;
        State state = State.INIT_FAILURE;
        Object impl = null;
        try {
            Class<?> binderFinal = binderClass = Class.forName(LOGGER_BINDER_NAME);
            MethodHandle getSingleton = InvocationHelper.cachedGetHandle(GET_SINGLETON, () -> InvocationHelper.staticHandle(binderFinal, "getSingleton", MethodType.methodType(binderFinal)).orElse(null));
            if (getSingleton == null) {
                ErrorUtil.report(String.format("%s does not have a getSingleton method", LOGGER_BINDER_NAME));
            } else {
                try {
                    impl = getSingleton.invoke();
                    state = State.INIT_SUCCESS;
                }
                catch (Throwable t2) {
                    ErrorUtil.report(String.format("%s#getSingleton() threw exception: %s", LOGGER_BINDER_NAME, t2.getMessage()));
                }
            }
        }
        catch (ClassNotFoundException e) {
            ErrorUtil.report(String.format("%s not found", LOGGER_BINDER_NAME));
        }
        BINDER_CLASS = binderClass;
        IMPL = impl;
        STATE = state;
        INSTANCE = new StaticMarkerBinder();
    }

    private static enum State {
        INIT_FAILURE,
        INIT_SUCCESS;

    }
}

