/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.S3Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDirectoryBucketsRequest
extends S3Request
implements ToCopyableBuilder<Builder, ListDirectoryBucketsRequest> {
    private static final SdkField<String> CONTINUATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ContinuationToken").getter(ListDirectoryBucketsRequest.getter(ListDirectoryBucketsRequest::continuationToken)).setter(ListDirectoryBucketsRequest.setter(Builder::continuationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("continuation-token").unmarshallLocationName("continuation-token").build()}).build();
    private static final SdkField<Integer> MAX_DIRECTORY_BUCKETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxDirectoryBuckets").getter(ListDirectoryBucketsRequest.getter(ListDirectoryBucketsRequest::maxDirectoryBuckets)).setter(ListDirectoryBucketsRequest.setter(Builder::maxDirectoryBuckets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-directory-buckets").unmarshallLocationName("max-directory-buckets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTINUATION_TOKEN_FIELD, MAX_DIRECTORY_BUCKETS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDirectoryBucketsRequest.memberNameToFieldInitializer();
    private final String continuationToken;
    private final Integer maxDirectoryBuckets;

    private ListDirectoryBucketsRequest(BuilderImpl builder) {
        super(builder);
        this.continuationToken = builder.continuationToken;
        this.maxDirectoryBuckets = builder.maxDirectoryBuckets;
    }

    public final String continuationToken() {
        return this.continuationToken;
    }

    public final Integer maxDirectoryBuckets() {
        return this.maxDirectoryBuckets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.continuationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDirectoryBuckets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDirectoryBucketsRequest)) {
            return false;
        }
        ListDirectoryBucketsRequest other = (ListDirectoryBucketsRequest)((Object)obj);
        return Objects.equals(this.continuationToken(), other.continuationToken()) && Objects.equals(this.maxDirectoryBuckets(), other.maxDirectoryBuckets());
    }

    public final String toString() {
        return ToString.builder((String)"ListDirectoryBucketsRequest").add("ContinuationToken", (Object)this.continuationToken()).add("MaxDirectoryBuckets", (Object)this.maxDirectoryBuckets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContinuationToken": {
                return Optional.ofNullable(clazz.cast(this.continuationToken()));
            }
            case "MaxDirectoryBuckets": {
                return Optional.ofNullable(clazz.cast(this.maxDirectoryBuckets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("continuation-token", CONTINUATION_TOKEN_FIELD);
        map.put("max-directory-buckets", MAX_DIRECTORY_BUCKETS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDirectoryBucketsRequest, T> g2) {
        return obj -> g2.apply((ListDirectoryBucketsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s2) {
        return (obj, val) -> s2.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends S3Request.BuilderImpl
    implements Builder {
        private String continuationToken;
        private Integer maxDirectoryBuckets;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDirectoryBucketsRequest model) {
            super(model);
            this.continuationToken(model.continuationToken);
            this.maxDirectoryBuckets(model.maxDirectoryBuckets);
        }

        public final String getContinuationToken() {
            return this.continuationToken;
        }

        public final void setContinuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
        }

        @Override
        public final Builder continuationToken(String continuationToken) {
            this.continuationToken = continuationToken;
            return this;
        }

        public final Integer getMaxDirectoryBuckets() {
            return this.maxDirectoryBuckets;
        }

        public final void setMaxDirectoryBuckets(Integer maxDirectoryBuckets) {
            this.maxDirectoryBuckets = maxDirectoryBuckets;
        }

        @Override
        public final Builder maxDirectoryBuckets(Integer maxDirectoryBuckets) {
            this.maxDirectoryBuckets = maxDirectoryBuckets;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDirectoryBucketsRequest build() {
            return new ListDirectoryBucketsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends S3Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDirectoryBucketsRequest> {
        public Builder continuationToken(String var1);

        public Builder maxDirectoryBuckets(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

