/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.S3TablesBucketType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DestinationResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DestinationResult> {
    private static final SdkField<String> TABLE_BUCKET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableBucketType").getter(DestinationResult.getter(DestinationResult::tableBucketTypeAsString)).setter(DestinationResult.setter(Builder::tableBucketType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableBucketType").unmarshallLocationName("TableBucketType").build()}).build();
    private static final SdkField<String> TABLE_BUCKET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableBucketArn").getter(DestinationResult.getter(DestinationResult::tableBucketArn)).setter(DestinationResult.setter(Builder::tableBucketArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableBucketArn").unmarshallLocationName("TableBucketArn").build()}).build();
    private static final SdkField<String> TABLE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableNamespace").getter(DestinationResult.getter(DestinationResult::tableNamespace)).setter(DestinationResult.setter(Builder::tableNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableNamespace").unmarshallLocationName("TableNamespace").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLE_BUCKET_TYPE_FIELD, TABLE_BUCKET_ARN_FIELD, TABLE_NAMESPACE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DestinationResult.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tableBucketType;
    private final String tableBucketArn;
    private final String tableNamespace;

    private DestinationResult(BuilderImpl builder) {
        this.tableBucketType = builder.tableBucketType;
        this.tableBucketArn = builder.tableBucketArn;
        this.tableNamespace = builder.tableNamespace;
    }

    public final S3TablesBucketType tableBucketType() {
        return S3TablesBucketType.fromValue(this.tableBucketType);
    }

    public final String tableBucketTypeAsString() {
        return this.tableBucketType;
    }

    public final String tableBucketArn() {
        return this.tableBucketArn;
    }

    public final String tableNamespace() {
        return this.tableNamespace;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableNamespace());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DestinationResult)) {
            return false;
        }
        DestinationResult other = (DestinationResult)obj;
        return Objects.equals(this.tableBucketTypeAsString(), other.tableBucketTypeAsString()) && Objects.equals(this.tableBucketArn(), other.tableBucketArn()) && Objects.equals(this.tableNamespace(), other.tableNamespace());
    }

    public final String toString() {
        return ToString.builder((String)"DestinationResult").add("TableBucketType", (Object)this.tableBucketTypeAsString()).add("TableBucketArn", (Object)this.tableBucketArn()).add("TableNamespace", (Object)this.tableNamespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TableBucketType": {
                return Optional.ofNullable(clazz.cast(this.tableBucketTypeAsString()));
            }
            case "TableBucketArn": {
                return Optional.ofNullable(clazz.cast(this.tableBucketArn()));
            }
            case "TableNamespace": {
                return Optional.ofNullable(clazz.cast(this.tableNamespace()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TableBucketType", TABLE_BUCKET_TYPE_FIELD);
        map.put("TableBucketArn", TABLE_BUCKET_ARN_FIELD);
        map.put("TableNamespace", TABLE_NAMESPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DestinationResult, T> g2) {
        return obj -> g2.apply((DestinationResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s2) {
        return (obj, val) -> s2.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tableBucketType;
        private String tableBucketArn;
        private String tableNamespace;

        private BuilderImpl() {
        }

        private BuilderImpl(DestinationResult model) {
            this.tableBucketType(model.tableBucketType);
            this.tableBucketArn(model.tableBucketArn);
            this.tableNamespace(model.tableNamespace);
        }

        public final String getTableBucketType() {
            return this.tableBucketType;
        }

        public final void setTableBucketType(String tableBucketType) {
            this.tableBucketType = tableBucketType;
        }

        @Override
        public final Builder tableBucketType(String tableBucketType) {
            this.tableBucketType = tableBucketType;
            return this;
        }

        @Override
        public final Builder tableBucketType(S3TablesBucketType tableBucketType) {
            this.tableBucketType(tableBucketType == null ? null : tableBucketType.toString());
            return this;
        }

        public final String getTableBucketArn() {
            return this.tableBucketArn;
        }

        public final void setTableBucketArn(String tableBucketArn) {
            this.tableBucketArn = tableBucketArn;
        }

        @Override
        public final Builder tableBucketArn(String tableBucketArn) {
            this.tableBucketArn = tableBucketArn;
            return this;
        }

        public final String getTableNamespace() {
            return this.tableNamespace;
        }

        public final void setTableNamespace(String tableNamespace) {
            this.tableNamespace = tableNamespace;
        }

        @Override
        public final Builder tableNamespace(String tableNamespace) {
            this.tableNamespace = tableNamespace;
            return this;
        }

        public DestinationResult build() {
            return new DestinationResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DestinationResult> {
        public Builder tableBucketType(String var1);

        public Builder tableBucketType(S3TablesBucketType var1);

        public Builder tableBucketArn(String var1);

        public Builder tableNamespace(String var1);
    }
}

