/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.utils.Lazy;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class UseS3ExpressAuthResolver {
    private static final Logger LOG = Logger.loggerFor(UseS3ExpressAuthResolver.class);
    private static final String DEFAULT_SETTING = "false";
    private final Lazy<Boolean> useS3ExpressAuth = new Lazy(() -> this.useS3ExpressAuth(() -> (ProfileFile)config.option((ClientOption)SdkClientOption.PROFILE_FILE), () -> (String)config.option((ClientOption)SdkClientOption.PROFILE_NAME)));

    public UseS3ExpressAuthResolver(SdkClientConfiguration config) {
    }

    public boolean resolve() {
        return (Boolean)this.useS3ExpressAuth.getValue();
    }

    private boolean useS3ExpressAuth(Supplier<ProfileFile> profileFile, Supplier<String> profileName) {
        String env = UseS3ExpressAuthResolver.envVarSetting();
        if (env != null) {
            return DEFAULT_SETTING.equalsIgnoreCase(env);
        }
        String profile = this.profileFileSetting(profileFile, profileName);
        if (profile != null) {
            return DEFAULT_SETTING.equalsIgnoreCase(profile);
        }
        return true;
    }

    private static String envVarSetting() {
        return SdkSystemSetting.AWS_S3_DISABLE_EXPRESS_SESSION_AUTH.getStringValue().orElse(null);
    }

    private String profileFileSetting(Supplier<ProfileFile> profileFileSupplier, Supplier<String> profileNameSupplier) {
        try {
            ProfileFile profileFile = profileFileSupplier.get();
            String profileName = profileNameSupplier.get();
            if (profileFile == null || profileName == null) {
                return null;
            }
            return profileFile.profile(profileName).flatMap(p -> p.property("s3_disable_express_session_auth")).orElse(null);
        }
        catch (Exception t2) {
            LOG.warn(() -> "Unable to load config file", (Throwable)t2);
            return null;
        }
    }
}

