/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Collection;
import java.util.Comparator;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.CloseableAsyncRequestBody;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.multipart.GenericMultipartHelper;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartUploadHelper;
import software.amazon.awssdk.services.s3.internal.multipart.SdkPojoConversionUtils;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.multipart.S3MultipartExecutionAttribute;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public final class UploadWithUnknownContentLengthHelper {
    private static final Logger log = Logger.loggerFor(UploadWithUnknownContentLengthHelper.class);
    private final S3AsyncClient s3AsyncClient;
    private final long partSizeInBytes;
    private final GenericMultipartHelper<PutObjectRequest, PutObjectResponse> genericMultipartHelper;
    private final long maxMemoryUsageInBytes;
    private final long multipartUploadThresholdInBytes;
    private final MultipartUploadHelper multipartUploadHelper;

    public UploadWithUnknownContentLengthHelper(S3AsyncClient s3AsyncClient, long partSizeInBytes, long multipartUploadThresholdInBytes, long maxMemoryUsageInBytes) {
        this.s3AsyncClient = s3AsyncClient;
        this.partSizeInBytes = partSizeInBytes;
        this.genericMultipartHelper = new GenericMultipartHelper<PutObjectRequest, PutObjectResponse>(s3AsyncClient, SdkPojoConversionUtils::toAbortMultipartUploadRequest, SdkPojoConversionUtils::toPutObjectResponse);
        this.maxMemoryUsageInBytes = maxMemoryUsageInBytes;
        this.multipartUploadThresholdInBytes = multipartUploadThresholdInBytes;
        this.multipartUploadHelper = new MultipartUploadHelper(s3AsyncClient, multipartUploadThresholdInBytes, maxMemoryUsageInBytes);
    }

    public CompletableFuture<PutObjectResponse> uploadObject(PutObjectRequest putObjectRequest, AsyncRequestBody asyncRequestBody) {
        CompletableFuture<PutObjectResponse> returnFuture = new CompletableFuture<PutObjectResponse>();
        SdkPublisher splitAsyncRequestBodyResponse = asyncRequestBody.splitCloseable(b -> b.chunkSizeInBytes(Long.valueOf(this.partSizeInBytes)).bufferSizeInBytes(Long.valueOf(this.maxMemoryUsageInBytes)));
        splitAsyncRequestBodyResponse.subscribe((Subscriber)new UnknownContentLengthAsyncRequestBodySubscriber(this.partSizeInBytes, putObjectRequest, returnFuture));
        return returnFuture;
    }

    private class UnknownContentLengthAsyncRequestBodySubscriber
    implements Subscriber<CloseableAsyncRequestBody> {
        private final AtomicBoolean isFirstAsyncRequestBody = new AtomicBoolean(true);
        private final AtomicBoolean createMultipartUploadInitiated = new AtomicBoolean(false);
        private final AtomicBoolean completedMultipartInitiated = new AtomicBoolean(false);
        private final AtomicInteger asyncRequestBodyInFlight = new AtomicInteger(0);
        private final AtomicBoolean failureActionInitiated = new AtomicBoolean(false);
        private AtomicInteger partNumber = new AtomicInteger(0);
        private AtomicLong contentLength = new AtomicLong(0L);
        private final Queue<CompletedPart> completedParts = new ConcurrentLinkedQueue<CompletedPart>();
        private final Collection<CompletableFuture<CompletedPart>> futures = new ConcurrentLinkedQueue<CompletableFuture<CompletedPart>>();
        private final CompletableFuture<String> uploadIdFuture = new CompletableFuture();
        private final long maximumChunkSizeInByte;
        private final PutObjectRequest putObjectRequest;
        private final CompletableFuture<PutObjectResponse> returnFuture;
        private final PublisherListener<Long> progressListener;
        private Subscription subscription;
        private CloseableAsyncRequestBody firstRequestBody;
        private String uploadId;
        private volatile boolean isDone;

        UnknownContentLengthAsyncRequestBodySubscriber(long maximumChunkSizeInByte, PutObjectRequest putObjectRequest, CompletableFuture<PutObjectResponse> returnFuture) {
            this.maximumChunkSizeInByte = maximumChunkSizeInByte;
            this.putObjectRequest = putObjectRequest;
            this.returnFuture = returnFuture;
            this.progressListener = putObjectRequest.overrideConfiguration().map(c -> (PublisherListener)c.executionAttributes().getAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER)).orElseGet(PublisherListener::noOp);
        }

        public void onSubscribe(Subscription s2) {
            if (this.subscription != null) {
                log.warn(() -> "The subscriber has already been subscribed. Cancelling the incoming subscription");
                this.subscription.cancel();
                return;
            }
            this.subscription = s2;
            s2.request(1L);
            this.returnFuture.whenComplete((r, t2) -> {
                if (t2 != null) {
                    s2.cancel();
                    UploadWithUnknownContentLengthHelper.this.multipartUploadHelper;
                    MultipartUploadHelper.cancelingOtherOngoingRequests(this.futures, t2);
                }
            });
        }

        public void onNext(CloseableAsyncRequestBody asyncRequestBody) {
            if (this.isDone) {
                return;
            }
            int currentPartNum = this.partNumber.incrementAndGet();
            log.trace(() -> "Received asyncRequestBody " + asyncRequestBody.contentLength());
            this.asyncRequestBodyInFlight.incrementAndGet();
            Optional<SdkClientException> sdkClientException = this.validatePart((AsyncRequestBody)asyncRequestBody, currentPartNum);
            if (sdkClientException.isPresent()) {
                UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.failRequestsElegantly(this.futures, sdkClientException.get(), this.uploadId, this.returnFuture, this.putObjectRequest);
                this.subscription.cancel();
                return;
            }
            if (this.isFirstAsyncRequestBody.compareAndSet(true, false)) {
                log.trace(() -> "Received first async request body");
                this.firstRequestBody = asyncRequestBody;
                this.subscription.request(1L);
                return;
            }
            if (this.createMultipartUploadInitiated.compareAndSet(false, true)) {
                log.debug(() -> "Starting the upload as multipart upload request");
                CompletableFuture<CreateMultipartUploadResponse> createMultipartUploadFuture = UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.createMultipartUpload(this.putObjectRequest, this.returnFuture);
                createMultipartUploadFuture.whenComplete((createMultipartUploadResponse, throwable) -> {
                    if (throwable != null) {
                        UploadWithUnknownContentLengthHelper.this.genericMultipartHelper.handleException(this.returnFuture, () -> "Failed to initiate multipart upload", (Throwable)throwable);
                        this.subscription.cancel();
                    } else {
                        this.uploadId = createMultipartUploadResponse.uploadId();
                        log.debug(() -> "Initiated a new multipart upload, uploadId: " + this.uploadId);
                        this.sendUploadPartRequest(this.uploadId, this.firstRequestBody, 1);
                        this.sendUploadPartRequest(this.uploadId, asyncRequestBody, 2);
                        this.uploadIdFuture.complete(this.uploadId);
                    }
                });
                CompletableFutureUtils.forwardExceptionTo(this.returnFuture, createMultipartUploadFuture);
            } else {
                this.uploadIdFuture.whenComplete((r, t2) -> this.sendUploadPartRequest(this.uploadId, asyncRequestBody, currentPartNum));
            }
        }

        private Optional<SdkClientException> validatePart(AsyncRequestBody asyncRequestBody, int currentPartNum) {
            Optional contentLength = asyncRequestBody.contentLength();
            if (!contentLength.isPresent()) {
                return Optional.of(MultipartUploadHelper.contentLengthMissingForPart(currentPartNum));
            }
            Long contentLengthCurrentPart = (Long)contentLength.get();
            if (contentLengthCurrentPart > UploadWithUnknownContentLengthHelper.this.partSizeInBytes) {
                return Optional.of(MultipartUploadHelper.contentLengthMismatchForPart(UploadWithUnknownContentLengthHelper.this.partSizeInBytes, contentLengthCurrentPart, currentPartNum));
            }
            return Optional.empty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendUploadPartRequest(String uploadId, CloseableAsyncRequestBody asyncRequestBody, int currentPartNum) {
            Long contentLengthCurrentPart = (Long)asyncRequestBody.contentLength().get();
            this.contentLength.getAndAdd(contentLengthCurrentPart);
            UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.sendIndividualUploadPartRequest(uploadId, this.completedParts::add, this.futures, this.uploadPart((AsyncRequestBody)asyncRequestBody, currentPartNum), this.progressListener).whenComplete((r, t2) -> {
                asyncRequestBody.close();
                if (t2 != null) {
                    if (this.failureActionInitiated.compareAndSet(false, true)) {
                        UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.failRequestsElegantly(this.futures, (Throwable)t2, uploadId, this.returnFuture, this.putObjectRequest);
                    }
                } else {
                    this.completeMultipartUploadIfFinish(this.asyncRequestBodyInFlight.decrementAndGet());
                }
            });
            UnknownContentLengthAsyncRequestBodySubscriber unknownContentLengthAsyncRequestBodySubscriber = this;
            synchronized (unknownContentLengthAsyncRequestBodySubscriber) {
                this.subscription.request(1L);
            }
        }

        private Pair<UploadPartRequest, AsyncRequestBody> uploadPart(AsyncRequestBody asyncRequestBody, int partNum) {
            UploadPartRequest uploadRequest = SdkPojoConversionUtils.toUploadPartRequest(this.putObjectRequest, partNum, this.uploadId);
            return Pair.of((Object)((Object)uploadRequest), (Object)asyncRequestBody);
        }

        public void onError(Throwable t2) {
            log.debug(() -> "Received onError() ", t2);
            if (this.failureActionInitiated.compareAndSet(false, true)) {
                this.isDone = true;
                UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.failRequestsElegantly(this.futures, t2, this.uploadId, this.returnFuture, this.putObjectRequest);
            }
        }

        public void onComplete() {
            log.debug(() -> "Received onComplete()");
            if (!this.createMultipartUploadInitiated.get()) {
                log.debug(() -> "Starting the upload as a single object upload request");
                UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.uploadInOneChunk(this.putObjectRequest, (AsyncRequestBody)this.firstRequestBody, this.returnFuture);
            } else {
                this.isDone = true;
                this.completeMultipartUploadIfFinish(this.asyncRequestBodyInFlight.get());
            }
        }

        private void completeMultipartUploadIfFinish(int requestsInFlight) {
            if (this.isDone && requestsInFlight == 0 && this.completedMultipartInitiated.compareAndSet(false, true)) {
                CompletedPart[] parts = (CompletedPart[])this.completedParts.stream().sorted(Comparator.comparingInt(CompletedPart::partNumber)).toArray(CompletedPart[]::new);
                long totalLength = this.contentLength.get();
                int expectedNumParts = UploadWithUnknownContentLengthHelper.this.genericMultipartHelper.determinePartCount(totalLength, UploadWithUnknownContentLengthHelper.this.partSizeInBytes);
                if (parts.length != expectedNumParts) {
                    SdkClientException exception = SdkClientException.create((String)String.format("The number of UploadParts requests is not equal to the expected number of parts. Expected: %d, Actual: %d", expectedNumParts, parts.length));
                    UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.failRequestsElegantly(this.futures, exception, this.uploadId, this.returnFuture, this.putObjectRequest);
                    return;
                }
                UploadWithUnknownContentLengthHelper.this.multipartUploadHelper.completeMultipartUpload(this.returnFuture, this.uploadId, parts, this.putObjectRequest, totalLength);
            }
        }
    }
}

