/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.multipart;

import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.internal.multipart.MultipartDownloadUtils;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class MultipartDownloaderSubscriber
implements Subscriber<AsyncResponseTransformer<GetObjectResponse, GetObjectResponse>> {
    private static final Logger log = Logger.loggerFor(MultipartDownloaderSubscriber.class);
    private final S3AsyncClient s3;
    private final GetObjectRequest getObjectRequest;
    private volatile Integer totalParts;
    private final AtomicInteger completedParts;
    private final AtomicInteger getObjectCallCount;
    private Subscription subscription;
    private final CompletableFuture<Void> future = new CompletableFuture();
    private volatile String eTag;
    private final Object lock = new Object();
    private final Queue<CompletableFuture<GetObjectResponse>> getObjectFutures = new ConcurrentLinkedQueue<CompletableFuture<GetObjectResponse>>();

    public MultipartDownloaderSubscriber(S3AsyncClient s3, GetObjectRequest getObjectRequest) {
        this(s3, getObjectRequest, 0);
    }

    public MultipartDownloaderSubscriber(S3AsyncClient s3, GetObjectRequest getObjectRequest, int completedParts) {
        this.s3 = s3;
        this.getObjectRequest = getObjectRequest;
        this.completedParts = new AtomicInteger(completedParts);
        this.getObjectCallCount = new AtomicInteger(completedParts);
    }

    public void onSubscribe(Subscription s2) {
        if (this.subscription != null) {
            s2.cancel();
            return;
        }
        this.subscription = s2;
        this.subscription.request(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNext(AsyncResponseTransformer<GetObjectResponse, GetObjectResponse> asyncResponseTransformer) {
        if (asyncResponseTransformer == null) {
            this.subscription.cancel();
            throw new NullPointerException("onNext must not be called with null asyncResponseTransformer");
        }
        int nextPartToGet = this.completedParts.get() + 1;
        Object object = this.lock;
        synchronized (object) {
            if (this.totalParts != null && nextPartToGet > this.totalParts) {
                log.debug(() -> String.format("Completing multipart download after a total of %d parts downloaded.", this.totalParts));
                this.subscription.cancel();
                return;
            }
        }
        GetObjectRequest actualRequest = this.nextRequest(nextPartToGet);
        log.debug(() -> "Sending GetObjectRequest for next part with partNumber=" + nextPartToGet);
        CompletableFuture<GetObjectResponse> getObjectFuture = this.s3.getObject(actualRequest, asyncResponseTransformer);
        this.getObjectCallCount.incrementAndGet();
        this.getObjectFutures.add(getObjectFuture);
        getObjectFuture.whenComplete((response, error) -> {
            if (error != null) {
                log.debug(() -> "Error encountered during GetObjectRequest with partNumber=" + nextPartToGet);
                this.handleError((Throwable)error);
                return;
            }
            this.requestMoreIfNeeded((GetObjectResponse)((Object)response));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestMoreIfNeeded(GetObjectResponse response) {
        Integer partCount;
        int totalComplete = this.completedParts.incrementAndGet();
        MultipartDownloadUtils.multipartDownloadResumeContext(this.getObjectRequest).ifPresent(ctx -> {
            ctx.addCompletedPart(totalComplete);
            ctx.addToBytesToLastCompletedParts(response.contentLength());
            if (ctx.response() == null) {
                ctx.response(response);
            }
        });
        log.debug(() -> String.format("Completed part %d", totalComplete));
        if (this.eTag == null) {
            this.eTag = response.eTag();
            log.debug(() -> String.format("Multipart object ETag: %s", this.eTag));
        }
        if ((partCount = response.partsCount()) != null && this.totalParts == null) {
            log.debug(() -> String.format("Total amount of parts of the object to download: %d", partCount));
            MultipartDownloadUtils.multipartDownloadResumeContext(this.getObjectRequest).ifPresent(ctx -> ctx.totalParts(partCount));
            this.totalParts = partCount;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.totalParts != null && this.totalParts > 1 && totalComplete < this.totalParts) {
                this.subscription.request(1L);
            } else {
                this.validatePartsCount();
                log.debug(() -> String.format("Completing multipart download after a total of %d parts downloaded.", this.totalParts));
                this.subscription.cancel();
            }
        }
    }

    public void onError(Throwable t2) {
        this.handleError(t2);
    }

    private void handleError(Throwable t2) {
        CompletableFuture<GetObjectResponse> partFuture;
        while ((partFuture = this.getObjectFutures.poll()) != null) {
            partFuture.cancel(true);
        }
        this.future.completeExceptionally(t2);
    }

    public void onComplete() {
        this.future.complete(null);
    }

    public CompletableFuture<Void> future() {
        return this.future;
    }

    private GetObjectRequest nextRequest(int nextPartToGet) {
        return (GetObjectRequest)this.getObjectRequest.copy(req -> {
            req.partNumber(nextPartToGet);
            if (this.eTag != null) {
                req.ifMatch(this.eTag);
            }
        });
    }

    private void validatePartsCount() {
        int actualGetCount = this.getObjectCallCount.get();
        if (this.totalParts != null && actualGetCount != this.totalParts) {
            String errorMessage = String.format("PartsCount validation failed. Expected %d, downloaded %d parts.", this.totalParts, actualGetCount);
            SdkClientException exception = SdkClientException.create((String)errorMessage);
            this.handleError(exception);
        }
    }
}

