/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.conf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.parquet.conf.ParquetConfiguration;

public class PlainParquetConfiguration
implements ParquetConfiguration {
    private final Map<String, String> map;

    public PlainParquetConfiguration() {
        this.map = new HashMap<String, String>();
    }

    public PlainParquetConfiguration(Map<String, String> properties) {
        this.map = new HashMap<String, String>(properties);
    }

    @Override
    public void set(String s2, String s1) {
        this.map.put(s2, s1);
    }

    @Override
    public void setLong(String name, long value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setInt(String name, int value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setBoolean(String name, boolean value) {
        this.set(name, String.valueOf(value));
    }

    @Override
    public void setStrings(String name, String ... value) {
        if (value.length > 0) {
            StringBuilder sb = new StringBuilder(value[0]);
            for (int i = 1; i < value.length; ++i) {
                sb.append(',');
                sb.append(value[i]);
            }
            this.set(name, sb.toString());
        } else {
            this.set(name, "");
        }
    }

    @Override
    public void setClass(String name, Class<?> value, Class<?> xface) {
        if (!xface.isAssignableFrom(value)) {
            throw new RuntimeException(xface.getCanonicalName() + " is not assignable from " + value.getCanonicalName());
        }
        this.set(name, value.getName());
    }

    @Override
    public String get(String name) {
        return this.map.get(name);
    }

    @Override
    public String get(String name, String defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return Long.parseLong(value);
        }
        return defaultValue;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    @Override
    public String getTrimmed(String name) {
        String value = this.get(name);
        if (value != null) {
            return value.trim();
        }
        return null;
    }

    @Override
    public String getTrimmed(String name, String defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return value.trim();
        }
        return defaultValue;
    }

    @Override
    public String[] getStrings(String name, String[] defaultValue) {
        String value = this.get(name);
        if (value != null) {
            return value.split(",");
        }
        return defaultValue;
    }

    @Override
    public Class<?> getClass(String name, Class<?> defaultValue) {
        String value = this.get(name);
        if (value != null) {
            try {
                return Class.forName(value);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return defaultValue;
    }

    @Override
    public <U> Class<? extends U> getClass(String name, Class<? extends U> defaultValue, Class<U> xface) {
        Class<U> value = this.getClass(name, defaultValue);
        if (value != null && value.isAssignableFrom(xface)) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public Class<?> getClassByName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return this.map.entrySet().iterator();
    }
}

