/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import java.io.IOException;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.statistics.S3AMultipartUploaderStatistics;
import org.apache.hadoop.fs.s3a.statistics.impl.AbstractS3AStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsBinding;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;

public final class S3AMultipartUploaderStatisticsImpl
extends AbstractS3AStatisticsSource
implements S3AMultipartUploaderStatistics {
    private final BiConsumer<Statistic, Long> incrementCallback;

    public S3AMultipartUploaderStatisticsImpl(BiConsumer<Statistic, Long> incrementCallback) {
        this.incrementCallback = Objects.requireNonNull(incrementCallback);
        IOStatisticsStore st = IOStatisticsBinding.iostatisticsStore().withCounters(Statistic.MULTIPART_UPLOAD_INSTANTIATED.getSymbol(), Statistic.MULTIPART_UPLOAD_PART_PUT.getSymbol(), Statistic.MULTIPART_UPLOAD_PART_PUT_BYTES.getSymbol(), Statistic.MULTIPART_UPLOAD_ABORTED.getSymbol(), Statistic.MULTIPART_UPLOAD_ABORT_UNDER_PATH_INVOKED.getSymbol(), Statistic.MULTIPART_UPLOAD_STARTED.getSymbol()).withDurationTracking(Statistic.MULTIPART_UPLOAD_COMPLETED.getSymbol(), Statistic.OBJECT_MULTIPART_UPLOAD_INITIATED.getSymbol(), Statistic.MULTIPART_UPLOAD_PART_PUT.getSymbol()).build();
        this.setIOStatistics(st);
    }

    private void inc(Statistic op, long count) {
        this.incrementCallback.accept(op, count);
        this.incCounter(op.getSymbol(), count);
    }

    @Override
    public void instantiated() {
        this.inc(Statistic.MULTIPART_UPLOAD_INSTANTIATED, 1L);
    }

    @Override
    public void uploadStarted() {
        this.inc(Statistic.MULTIPART_UPLOAD_STARTED, 1L);
    }

    @Override
    public void partPut(long lengthInBytes) {
        this.inc(Statistic.MULTIPART_UPLOAD_PART_PUT_BYTES, lengthInBytes);
    }

    @Override
    public void uploadCompleted() {
    }

    @Override
    public void uploadAborted() {
        this.inc(Statistic.MULTIPART_UPLOAD_ABORTED, 1L);
    }

    @Override
    public void abortUploadsUnderPathInvoked() {
        this.inc(Statistic.MULTIPART_UPLOAD_ABORT_UNDER_PATH_INVOKED, 1L);
    }

    @Override
    public void close() throws IOException {
    }
}

