/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.statistics.impl;

import java.time.Duration;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.s3a.statistics.StatisticsFromAwsSdk;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.metrics.MetricCollection;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.SdkMetric;

public class AwsStatisticsCollector
implements MetricPublisher {
    private final StatisticsFromAwsSdk collector;

    public AwsStatisticsCollector(StatisticsFromAwsSdk collector) {
        this.collector = collector;
    }

    public void publish(MetricCollection metricCollection) {
        long[] throttling = new long[]{0L};
        AwsStatisticsCollector.recurseThroughChildren(metricCollection).collect(Collectors.toList()).forEach(m4 -> {
            this.counter((MetricCollection)m4, (SdkMetric<Integer>)CoreMetric.RETRY_COUNT, retries -> {
                this.collector.updateAwsRetryCount(retries);
                this.collector.updateAwsRequestCount(retries + 1L);
            });
            this.counter((MetricCollection)m4, (SdkMetric<Integer>)HttpMetric.HTTP_STATUS_CODE, statusCode -> {
                if (statusCode == 429L) {
                    throttling[0] = throttling[0] + 1L;
                }
            });
            this.timing((MetricCollection)m4, (SdkMetric<Duration>)CoreMetric.API_CALL_DURATION, this.collector::noteAwsClientExecuteTime);
            this.timing((MetricCollection)m4, (SdkMetric<Duration>)CoreMetric.SERVICE_CALL_DURATION, this.collector::noteAwsRequestTime);
            this.timing((MetricCollection)m4, (SdkMetric<Duration>)CoreMetric.MARSHALLING_DURATION, this.collector::noteRequestMarshallTime);
            this.timing((MetricCollection)m4, (SdkMetric<Duration>)CoreMetric.SIGNING_DURATION, this.collector::noteRequestSigningTime);
            this.timing((MetricCollection)m4, (SdkMetric<Duration>)CoreMetric.UNMARSHALLING_DURATION, this.collector::noteResponseProcessingTime);
        });
        this.collector.updateAwsThrottleExceptionsCount(throttling[0]);
    }

    public void close() {
    }

    private void timing(MetricCollection collection, SdkMetric<Duration> metric, Consumer<Duration> durationConsumer) {
        collection.metricValues(metric).forEach(v -> durationConsumer.accept((Duration)v));
    }

    private void counter(MetricCollection collection, SdkMetric<Integer> metric, LongConsumer consumer) {
        collection.metricValues(metric).forEach(v -> consumer.accept(v.longValue()));
    }

    private static Stream<MetricCollection> recurseThroughChildren(MetricCollection metrics) {
        return Stream.concat(Stream.of(metrics), metrics.children().stream().flatMap(c -> AwsStatisticsCollector.recurseThroughChildren(c)));
    }
}

