/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.prefetch.BlockData;
import org.apache.hadoop.fs.impl.prefetch.FilePosition;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.ChangeTracker;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.s3a.prefetch.PrefetchOptions;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObject;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObjectReader;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class S3ARemoteInputStream
extends InputStream
implements CanSetReadahead,
StreamCapabilities,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(S3ARemoteInputStream.class);
    private S3ARemoteObject remoteObject;
    private S3ARemoteObjectReader reader;
    private final String name;
    private volatile boolean closed;
    private FilePosition fpos;
    private long nextReadPos;
    private BlockData blockData;
    private S3AReadOpContext context;
    private S3ObjectAttributes s3Attributes;
    private ObjectInputStreamCallbacks client;
    private final S3AInputStreamStatistics streamStatistics;
    private S3AInputPolicy inputPolicy;
    private final ChangeTracker changeTracker;
    private final IOStatistics ioStatistics;

    public S3ARemoteInputStream(S3AReadOpContext context, PrefetchOptions prefetchOptions, S3ObjectAttributes s3Attributes, ObjectInputStreamCallbacks client, S3AInputStreamStatistics streamStatistics) {
        this.context = Objects.requireNonNull(context);
        this.s3Attributes = Objects.requireNonNull(s3Attributes);
        this.client = Objects.requireNonNull(client);
        this.streamStatistics = Objects.requireNonNull(streamStatistics);
        this.ioStatistics = streamStatistics.getIOStatistics();
        this.name = S3ARemoteObject.getPath(s3Attributes);
        this.changeTracker = new ChangeTracker(this.name, context.getChangeDetectionPolicy(), this.streamStatistics.getChangeTrackerStatistics(), s3Attributes);
        this.setInputPolicy(context.getInputPolicy());
        this.setReadahead(context.getReadahead());
        long fileSize = s3Attributes.getLen();
        int bufferSize = prefetchOptions.getPrefetchBlockSize();
        this.blockData = new BlockData(fileSize, bufferSize);
        this.fpos = new FilePosition(fileSize, bufferSize);
        this.remoteObject = this.getS3File();
        this.reader = new S3ARemoteObjectReader(this.remoteObject);
        this.nextReadPos = 0L;
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.ioStatistics;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public S3AInputStreamStatistics getS3AStreamStatistics() {
        return this.streamStatistics;
    }

    @Override
    public synchronized void setReadahead(Long readahead) {
        if (readahead != null) {
            Validate.checkNotNegative(readahead, "readahead");
        }
    }

    @Override
    public boolean hasCapability(String capability) {
        return capability.equalsIgnoreCase("iostatistics") || capability.equalsIgnoreCase("in:readahead");
    }

    private void setInputPolicy(S3AInputPolicy inputPolicy) {
        this.inputPolicy = inputPolicy;
        this.streamStatistics.inputPolicySet(inputPolicy.ordinal());
    }

    @Override
    public int available() throws IOException {
        this.throwIfClosed();
        if (!this.fpos.setAbsolute(this.nextReadPos)) {
            return 0;
        }
        return this.fpos.buffer().remaining();
    }

    public long getPos() throws IOException {
        this.throwIfClosed();
        return this.nextReadPos;
    }

    public void seek(long pos) throws IOException {
        this.throwIfClosed();
        this.throwIfInvalidSeek(pos);
        this.nextReadPos = pos;
    }

    protected abstract boolean ensureCurrentBuffer() throws IOException;

    @Override
    public int read() throws IOException {
        this.throwIfClosed();
        if (this.remoteObject.size() == 0L || this.nextReadPos >= this.remoteObject.size()) {
            return -1;
        }
        if (!this.ensureCurrentBuffer()) {
            return -1;
        }
        ++this.nextReadPos;
        this.incrementBytesRead(1);
        return this.fpos.buffer().get() & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        this.throwIfClosed();
        if (len == 0) {
            return 0;
        }
        if (this.remoteObject.size() == 0L || this.nextReadPos >= this.remoteObject.size()) {
            return -1;
        }
        if (!this.ensureCurrentBuffer()) {
            return -1;
        }
        int numBytesRead = 0;
        int numBytesRemaining = len;
        while (numBytesRemaining > 0 && this.ensureCurrentBuffer()) {
            ByteBuffer buf = this.fpos.buffer();
            int bytesToRead = Math.min(numBytesRemaining, buf.remaining());
            buf.get(buffer, offset, bytesToRead);
            this.nextReadPos += (long)bytesToRead;
            this.incrementBytesRead(bytesToRead);
            offset += bytesToRead;
            numBytesRemaining -= bytesToRead;
            numBytesRead += bytesToRead;
        }
        return numBytesRead;
    }

    protected S3ARemoteObject getFile() {
        return this.remoteObject;
    }

    protected S3ARemoteObjectReader getReader() {
        return this.reader;
    }

    protected S3ObjectAttributes getS3ObjectAttributes() {
        return this.s3Attributes;
    }

    protected FilePosition getFilePosition() {
        return this.fpos;
    }

    protected String getName() {
        return this.name;
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected long getNextReadPos() {
        return this.nextReadPos;
    }

    protected BlockData getBlockData() {
        return this.blockData;
    }

    protected S3AReadOpContext getContext() {
        return this.context;
    }

    private void incrementBytesRead(int bytesRead) {
        if (bytesRead > 0) {
            this.streamStatistics.bytesRead(bytesRead);
            if (this.getContext().getStats() != null) {
                this.getContext().getStats().incrementBytesRead(bytesRead);
            }
            this.fpos.incrementBytesRead(bytesRead);
        }
    }

    protected S3ARemoteObject getS3File() {
        return new S3ARemoteObject(this.context, this.s3Attributes, this.client, this.streamStatistics, this.changeTracker);
    }

    protected String getOffsetStr(long offset) {
        int blockNumber = -1;
        if (this.blockData.isValidOffset(offset)) {
            blockNumber = this.blockData.getBlockNumber(offset);
        }
        return String.format("%d:%d", blockNumber, offset);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.blockData = null;
        this.reader.close();
        this.reader = null;
        this.remoteObject = null;
        this.fpos.invalidate();
        try {
            this.client.close();
        }
        finally {
            this.streamStatistics.close();
        }
        this.client = null;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    public String toString() {
        if (this.isClosed()) {
            return "closed";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("nextReadPos = (%d)%n", this.nextReadPos));
        sb.append(String.format("fpos = (%s)", this.fpos));
        return sb.toString();
    }

    protected void throwIfClosed() throws IOException {
        if (this.closed) {
            throw new IOException(this.name + ": " + "Stream is closed!");
        }
    }

    protected void throwIfInvalidSeek(long pos) throws EOFException {
        if (pos < 0L) {
            throw new EOFException("Cannot seek to a negative offset " + pos);
        }
        if (pos > this.getBlockData().getFileSize()) {
            throw new EOFException("Attempted to seek or read past the end of the file " + pos);
        }
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public long skip(long n) {
        throw new UnsupportedOperationException("skip not supported");
    }
}

