/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CanSetReadahead;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.prefetch.PrefetchOptions;
import org.apache.hadoop.fs.s3a.prefetch.S3ACachingInputStream;
import org.apache.hadoop.fs.s3a.prefetch.S3AInMemoryInputStream;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteInputStream;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3APrefetchingInputStream
extends ObjectInputStream
implements CanSetReadahead,
StreamCapabilities,
IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(S3APrefetchingInputStream.class);
    private S3ARemoteInputStream inputStream;
    private long lastReadCurrentPos = 0L;
    private IOStatistics ioStatistics = null;
    private S3AInputStreamStatistics inputStreamStatistics = null;

    public S3APrefetchingInputStream(ObjectReadParameters parameters, Configuration conf, PrefetchOptions prefetchOptions) {
        super(InputStreamType.Prefetch, parameters);
        S3ObjectAttributes s3Attributes = parameters.getObjectAttributes();
        ObjectInputStreamCallbacks client = parameters.getCallbacks();
        S3AInputStreamStatistics streamStatistics = parameters.getStreamStatistics();
        S3AReadOpContext context = parameters.getContext();
        LocalDirAllocator localDirAllocator = parameters.getDirectoryAllocator();
        Validate.checkNotNull(context, "context");
        Validate.checkNotNull(s3Attributes, "s3Attributes");
        Validate.checkNotNullAndNotEmpty(s3Attributes.getBucket(), "s3Attributes.getBucket()");
        Validate.checkNotNullAndNotEmpty(s3Attributes.getKey(), "s3Attributes.getKey()");
        Validate.checkNotNegative(s3Attributes.getLen(), "s3Attributes.getLen()");
        Validate.checkNotNull(client, "client");
        Validate.checkNotNull(streamStatistics, "streamStatistics");
        long fileSize = s3Attributes.getLen();
        if (fileSize <= (long)prefetchOptions.getPrefetchBlockSize()) {
            LOG.debug("Creating in memory input stream for {}", (Object)context.getPath());
            this.inputStream = new S3AInMemoryInputStream(context, prefetchOptions, s3Attributes, client, streamStatistics);
        } else {
            LOG.debug("Creating in caching input stream for {}", (Object)context.getPath());
            this.inputStream = new S3ACachingInputStream(context, prefetchOptions, s3Attributes, client, streamStatistics, conf, localDirAllocator);
        }
    }

    @Override
    public synchronized int available() throws IOException {
        this.throwIfClosed();
        return this.inputStream.available();
    }

    @Override
    public synchronized long getPos() throws IOException {
        if (!this.isClosed()) {
            this.lastReadCurrentPos = this.inputStream.getPos();
        }
        return this.lastReadCurrentPos;
    }

    @Override
    public synchronized int read() throws IOException {
        this.throwIfClosed();
        return this.inputStream.read();
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int len) throws IOException {
        this.throwIfClosed();
        return this.inputStream.read(buffer, offset, len);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
            this.inputStream = null;
            super.close();
        }
    }

    @Override
    protected boolean isStreamOpen() {
        return !this.isClosed();
    }

    @Override
    protected void abortInFinalizer() {
        this.getS3AStreamStatistics().streamLeaked();
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void seek(long pos) throws IOException {
        this.throwIfClosed();
        this.inputStream.seek(pos);
    }

    @Override
    public synchronized void setReadahead(Long readahead) {
        if (!this.isClosed()) {
            this.inputStream.setReadahead(readahead);
        }
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase(capability)) {
            case "in:readahead": {
                return true;
            }
        }
        return super.hasCapability(capability);
    }

    @Override
    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    @VisibleForTesting
    public S3AInputStreamStatistics getS3AStreamStatistics() {
        if (!this.isClosed()) {
            this.inputStreamStatistics = this.inputStream.getS3AStreamStatistics();
        }
        return this.inputStreamStatistics;
    }

    @Override
    public IOStatistics getIOStatistics() {
        if (!this.isClosed()) {
            this.ioStatistics = this.inputStream.getIOStatistics();
        }
        return this.ioStatistics;
    }

    protected boolean isClosed() {
        return this.inputStream == null;
    }

    protected void throwIfClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Stream is closed!");
        }
    }

    @Override
    public boolean seekToNewSource(long targetPos) throws IOException {
        return false;
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

