/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import org.apache.hadoop.fs.impl.prefetch.BlockManagerParameters;
import org.apache.hadoop.fs.impl.prefetch.CachingBlockManager;
import org.apache.hadoop.fs.impl.prefetch.Validate;
import org.apache.hadoop.fs.s3a.prefetch.S3ARemoteObjectReader;

public class S3ACachingBlockManager
extends CachingBlockManager {
    private final S3ARemoteObjectReader reader;

    public S3ACachingBlockManager(@Nonnull BlockManagerParameters blockManagerParameters, S3ARemoteObjectReader reader) {
        super(blockManagerParameters);
        Validate.checkNotNull(reader, "reader");
        this.reader = reader;
    }

    protected S3ARemoteObjectReader getReader() {
        return this.reader;
    }

    @Override
    public int read(ByteBuffer buffer, long startOffset, int size) throws IOException {
        return this.reader.read(buffer, startOffset, size);
    }

    @Override
    public synchronized void close() {
        this.reader.close();
        super.close();
    }
}

