/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.prefetch;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.VectoredIOContext;
import org.apache.hadoop.fs.s3a.impl.streams.AbstractObjectInputStreamFactory;
import org.apache.hadoop.fs.s3a.impl.streams.InputStreamType;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStream;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectReadParameters;
import org.apache.hadoop.fs.s3a.impl.streams.StreamFactoryRequirements;
import org.apache.hadoop.fs.s3a.impl.streams.StreamIntegration;
import org.apache.hadoop.fs.s3a.prefetch.PrefetchOptions;
import org.apache.hadoop.fs.s3a.prefetch.S3APrefetchingInputStream;
import org.apache.hadoop.util.Preconditions;

public class PrefetchingInputStreamFactory
extends AbstractObjectInputStreamFactory {
    private int prefetchBlockSize;
    private int prefetchBlockCount;
    private PrefetchOptions prefetchOptions;

    public PrefetchingInputStreamFactory() {
        super("PrefetchingInputStreamFactory");
    }

    @Override
    public InputStreamType streamType() {
        return InputStreamType.Prefetch;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        super.serviceInit(conf);
        long prefetchBlockSizeLong = S3AUtils.longBytesOption(conf, "fs.s3a.prefetch.block.size", 0x800000L, 1L);
        Preconditions.checkState(prefetchBlockSizeLong < Integer.MAX_VALUE, "S3A prefetch block size exceeds int limit");
        this.prefetchBlockSize = (int)prefetchBlockSizeLong;
        this.prefetchBlockCount = S3AUtils.intOption(conf, "fs.s3a.prefetch.block.count", 8, 1);
        this.prefetchOptions = new PrefetchOptions(this.prefetchBlockSize, this.prefetchBlockCount);
    }

    @Override
    public ObjectInputStream readObject(ObjectReadParameters parameters) throws IOException {
        return new S3APrefetchingInputStream(parameters, this.getConfig(), this.prefetchOptions);
    }

    @Override
    public StreamFactoryRequirements factoryRequirements() {
        VectoredIOContext vectorContext = StreamIntegration.populateVectoredIOContext(this.getConfig()).setMinSeekForVectoredReads(0);
        return new StreamFactoryRequirements(this.prefetchBlockCount, 0, vectorContext, StreamFactoryRequirements.Requirements.RequiresFuturePool);
    }
}

