/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.io.IOException;
import org.apache.hadoop.fs.s3a.impl.streams.FactoryBindingParameters;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;

public abstract class AbstractObjectInputStreamFactory
extends AbstractService
implements ObjectInputStreamFactory {
    private FactoryBindingParameters bindingParameters;
    private ObjectInputStreamFactory.StreamFactoryCallbacks callbacks;

    protected AbstractObjectInputStreamFactory(String name) {
        super(name);
    }

    @Override
    public void bind(FactoryBindingParameters factoryBindingParameters) throws IOException {
        Preconditions.checkState(this.isInState(Service.STATE.INITED), "Input Stream factory %s is in wrong state: %s", new Object[]{this, this.getServiceState()});
        this.bindingParameters = factoryBindingParameters;
        this.callbacks = this.bindingParameters.callbacks();
    }

    @Override
    public boolean hasCapability(String capability) {
        switch (StringUtils.toLowerCase(capability)) {
            case "iostatistics": 
            case "stream_leaks": {
                return true;
            }
        }
        return this.streamType().capability().equals(capability);
    }

    protected ObjectInputStreamFactory.StreamFactoryCallbacks callbacks() {
        return this.callbacks;
    }
}

