/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.logging;

import org.apache.hadoop.fs.s3a.impl.logging.LogControl;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LogControllerFactory.class);
    private static final LogExactlyOnce LOG_ONCE = new LogExactlyOnce(LOG);
    private static final String LOG4J_CONTROLLER = "org.apache.hadoop.fs.s3a.impl.logging.Log4JController";

    private LogControllerFactory() {
    }

    public static LogControl createController(String classname) {
        try {
            Class<?> clazz = Class.forName(classname);
            return (LogControl)clazz.newInstance();
        }
        catch (Exception e) {
            LOG_ONCE.debug("Failed to create controller {}: {}", classname, e, e);
            return null;
        }
    }

    public static LogControl createLog4JController() {
        return LogControllerFactory.createController(LOG4J_CONTROLLER);
    }

    public static LogControl createController() {
        LogControl controller = LogControllerFactory.createLog4JController();
        return controller != null ? controller : new StubLogControl();
    }

    private static final class StubLogControl
    extends LogControl {
        private StubLogControl() {
        }

        @Override
        protected boolean setLevel(String log, LogControl.LogLevel level) {
            return false;
        }
    }
}

