/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.impl.FlagSet;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3AInputPolicy;
import org.apache.hadoop.fs.s3a.S3AStorageStatistics;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.api.PerformanceFlagEnum;
import org.apache.hadoop.fs.s3a.api.RequestFactory;
import org.apache.hadoop.fs.s3a.audit.AuditSpanS3A;
import org.apache.hadoop.fs.s3a.impl.ChangeDetectionPolicy;
import org.apache.hadoop.fs.s3a.impl.ContextAccessors;
import org.apache.hadoop.fs.s3a.statistics.S3AStatisticsContext;
import org.apache.hadoop.fs.store.audit.ActiveThreadSpanSource;
import org.apache.hadoop.fs.store.audit.AuditSpan;
import org.apache.hadoop.fs.store.audit.AuditSpanSource;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ListeningExecutorService;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.MoreExecutors;
import org.apache.hadoop.util.LambdaUtils;
import org.apache.hadoop.util.SemaphoredDelegatingExecutor;

@InterfaceAudience.LimitedPrivate(value={"S3A Filesystem and extensions"})
@InterfaceStability.Unstable
public class StoreContext
implements ActiveThreadSpanSource<AuditSpan> {
    private final URI fsURI;
    private final String bucket;
    private final Configuration configuration;
    private final String username;
    private final UserGroupInformation owner;
    private final ListeningExecutorService executor;
    private final int executorCapacity;
    private final Invoker invoker;
    private final S3AStatisticsContext instrumentation;
    private final S3AStorageStatistics storageStatistics;
    private final S3AInputPolicy inputPolicy;
    private final ChangeDetectionPolicy changeDetectionPolicy;
    private final boolean multiObjectDeleteEnabled;
    private final boolean useListV1;
    private final ContextAccessors contextAccessors;
    private final AuditSpanSource<AuditSpanS3A> auditor;
    private final boolean isCSEEnabled;
    private final FlagSet<PerformanceFlagEnum> performanceFlags;

    StoreContext(URI fsURI, String bucket, Configuration configuration, String username, UserGroupInformation owner, ExecutorService executor, int executorCapacity, Invoker invoker, S3AStatisticsContext instrumentation, S3AStorageStatistics storageStatistics, S3AInputPolicy inputPolicy, ChangeDetectionPolicy changeDetectionPolicy, boolean multiObjectDeleteEnabled, boolean useListV1, ContextAccessors contextAccessors, AuditSpanSource<AuditSpanS3A> auditor, boolean isCSEEnabled, FlagSet<PerformanceFlagEnum> performanceFlags) {
        this.fsURI = fsURI;
        this.bucket = bucket;
        this.configuration = configuration;
        this.username = username;
        this.owner = owner;
        this.executor = executor != null ? MoreExecutors.listeningDecorator(executor) : null;
        this.executorCapacity = executorCapacity;
        this.invoker = invoker;
        this.instrumentation = instrumentation;
        this.storageStatistics = storageStatistics;
        this.inputPolicy = inputPolicy;
        this.changeDetectionPolicy = changeDetectionPolicy;
        this.multiObjectDeleteEnabled = multiObjectDeleteEnabled;
        this.useListV1 = useListV1;
        this.contextAccessors = contextAccessors;
        this.auditor = auditor;
        this.isCSEEnabled = isCSEEnabled;
        this.performanceFlags = performanceFlags;
    }

    public URI getFsURI() {
        return this.fsURI;
    }

    public String getBucket() {
        return this.bucket;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getUsername() {
        return this.username;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public S3AStatisticsContext getInstrumentation() {
        return this.instrumentation;
    }

    public S3AInputPolicy getInputPolicy() {
        return this.inputPolicy;
    }

    public ChangeDetectionPolicy getChangeDetectionPolicy() {
        return this.changeDetectionPolicy;
    }

    public boolean isMultiObjectDeleteEnabled() {
        return this.multiObjectDeleteEnabled;
    }

    public boolean isUseListV1() {
        return this.useListV1;
    }

    public ContextAccessors getContextAccessors() {
        return this.contextAccessors;
    }

    public Path keyToPath(String key) {
        return this.contextAccessors.keyToPath(key);
    }

    public String pathToKey(Path path) {
        return this.contextAccessors.pathToKey(path);
    }

    public Path makeQualified(Path path) {
        return this.contextAccessors.makeQualified(path);
    }

    public S3AStorageStatistics getStorageStatistics() {
        return this.storageStatistics;
    }

    public void incrementStatistic(Statistic statistic) {
        this.incrementStatistic(statistic, 1L);
    }

    public void incrementStatistic(Statistic statistic, long count) {
        this.instrumentation.incrementCounter(statistic, count);
    }

    public void decrementGauge(Statistic statistic, long count) {
        this.instrumentation.decrementGauge(statistic, count);
    }

    public void incrementGauge(Statistic statistic, long count) {
        this.instrumentation.incrementGauge(statistic, count);
    }

    public ExecutorService createThrottledExecutor(int capacity) {
        return new SemaphoredDelegatingExecutor(this.executor, capacity, true);
    }

    public ExecutorService createThrottledExecutor() {
        return this.createThrottledExecutor(this.executorCapacity);
    }

    public UserGroupInformation getOwner() {
        return this.owner;
    }

    public File createTempFile(String prefix, long size) throws IOException {
        return this.contextAccessors.createTempFile(prefix, size);
    }

    public String getBucketLocation() throws IOException {
        return this.contextAccessors.getBucketLocation();
    }

    public String fullKey(S3AFileStatus stat) {
        String k = this.pathToKey(stat.getPath());
        return stat.isDirectory() && !k.endsWith("/") ? k + "/" : k;
    }

    public <T> CompletableFuture<T> submit(CompletableFuture<T> future, Callable<T> call) {
        this.getExecutor().submit(() -> LambdaUtils.eval(future, call));
        return future;
    }

    public AuditSpanSource<AuditSpanS3A> getAuditor() {
        return this.auditor;
    }

    @Override
    public AuditSpan getActiveAuditSpan() {
        return this.contextAccessors.getActiveAuditSpan();
    }

    public RequestFactory getRequestFactory() {
        return this.contextAccessors.getRequestFactory();
    }

    public boolean isCSEEnabled() {
        return this.isCSEEnabled;
    }

    public FlagSet<PerformanceFlagEnum> getPerformanceFlags() {
        return this.performanceFlags;
    }
}

