/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.S3AFileStatus;
import org.apache.hadoop.fs.s3a.S3ALocatedFileStatus;
import org.apache.hadoop.fs.s3a.impl.ExecutingStoreOperation;
import org.apache.hadoop.fs.s3a.impl.StatusProbeEnum;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.apache.hadoop.fs.statistics.IOStatistics;
import org.apache.hadoop.fs.statistics.IOStatisticsSnapshot;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.IOStatisticsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetContentSummaryOperation
extends ExecutingStoreOperation<ContentSummary>
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(GetContentSummaryOperation.class);
    private final Path path;
    private final GetContentSummaryCallbacks callbacks;
    private final IOStatisticsSnapshot iostatistics = new IOStatisticsSnapshot();

    public GetContentSummaryOperation(StoreContext storeContext, Path path, GetContentSummaryCallbacks callbacks) {
        super(storeContext);
        this.path = path;
        this.callbacks = callbacks;
    }

    @Override
    public IOStatistics getIOStatistics() {
        return this.iostatistics;
    }

    @Override
    public ContentSummary execute() throws IOException {
        S3AFileStatus status = this.probePathStatusOrNull(this.path, StatusProbeEnum.FILE);
        if (status != null && status.isFile()) {
            long length = status.getLen();
            return new ContentSummary.Builder().length(length).fileCount(1L).directoryCount(0L).spaceConsumed(length).build();
        }
        ContentSummary summary = this.getDirSummary(this.path);
        LOG.debug("IOStatistics of getContentSummary({}):\n{}", (Object)this.path, (Object)this.iostatistics);
        return summary;
    }

    public ContentSummary getDirSummary(Path dir) throws IOException {
        long totalLength = 0L;
        long fileCount = 0L;
        long dirCount = 1L;
        RemoteIterator<S3ALocatedFileStatus> it = this.callbacks.listFilesIterator(dir, true);
        HashSet<Path> dirSet = new HashSet<Path>();
        HashSet<Path> pathsTraversed = new HashSet<Path>();
        while (it.hasNext()) {
            S3ALocatedFileStatus fileStatus = it.next();
            Path filePath = fileStatus.getPath();
            if (fileStatus.isDirectory() && !filePath.equals(dir)) {
                dirSet.add(filePath);
                this.buildDirectorySet(dirSet, pathsTraversed, dir, filePath.getParent());
                continue;
            }
            if (fileStatus.isDirectory()) continue;
            ++fileCount;
            totalLength += fileStatus.getLen();
            this.buildDirectorySet(dirSet, pathsTraversed, dir, filePath.getParent());
        }
        this.iostatistics.aggregate(IOStatisticsSupport.retrieveIOStatistics(it));
        return new ContentSummary.Builder().length(totalLength).fileCount(fileCount).directoryCount(dirCount + (long)dirSet.size()).spaceConsumed(totalLength).build();
    }

    private void buildDirectorySet(Set<Path> dirSet, Set<Path> pathsTraversed, Path basePath, Path parentPath) {
        if (parentPath == null || pathsTraversed.contains(parentPath) || parentPath.equals(basePath)) {
            return;
        }
        dirSet.add(parentPath);
        this.buildDirectorySet(dirSet, pathsTraversed, basePath, parentPath.getParent());
        pathsTraversed.add(parentPath);
    }

    private S3AFileStatus probePathStatusOrNull(Path p, Set<StatusProbeEnum> probes) throws IOException {
        try {
            return this.callbacks.probePathStatus(p, probes);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    public static interface GetContentSummaryCallbacks {
        public S3AFileStatus probePathStatus(Path var1, Set<StatusProbeEnum> var2) throws IOException;

        public RemoteIterator<S3ALocatedFileStatus> listFilesIterator(Path var1, boolean var2) throws IOException;
    }
}

