/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.store.LogExactlyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class ConfigurationHelper {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationHelper.class);
    private static final LogExactlyOnce DURATION_WARN_LOG = new LogExactlyOnce(LOG);

    private ConfigurationHelper() {
    }

    public static Duration getDuration(Configuration conf, String name, Duration defaultDuration, TimeUnit defaultUnit, @Nullable Duration minimumDuration) {
        long timeMillis = conf.getTimeDuration(name, defaultDuration.toMillis(), defaultUnit, TimeUnit.MILLISECONDS);
        if (timeMillis > Integer.MAX_VALUE) {
            DURATION_WARN_LOG.warn("Option {} is too high({} ms). Setting to {} ms instead", name, timeMillis, Integer.MAX_VALUE);
            LOG.debug("Option {} is too high({} ms). Setting to {} ms instead", name, timeMillis, Integer.MAX_VALUE);
            timeMillis = Integer.MAX_VALUE;
        }
        Duration duration = ConfigurationHelper.enforceMinimumDuration(name, Duration.ofMillis(timeMillis), minimumDuration);
        LOG.debug("Duration of {} = {}", (Object)name, (Object)duration);
        return duration;
    }

    public static void setDurationAsSeconds(Configuration conf, String name, Duration duration) {
        conf.set(name, duration.getSeconds() + "s");
    }

    public static void setDurationAsMillis(Configuration conf, String name, Duration duration) {
        conf.set(name, duration.toMillis() + "ms");
    }

    public static Duration enforceMinimumDuration(String name, Duration duration, @Nullable Duration minimumDuration) {
        if (minimumDuration != null && duration.compareTo(minimumDuration) < 0) {
            String message = String.format("Option %s is too low (%,d ms). Setting to %,d ms instead", name, duration.toMillis(), minimumDuration.toMillis());
            DURATION_WARN_LOG.warn(message, new Object[0]);
            LOG.debug(message);
            return minimumDuration;
        }
        return duration;
    }
}

